% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob.R
\name{check_prob}
\alias{check_prob}
\alias{check_probability}
\alias{check_prop}
\title{Check Probability}
\usage{
check_prob(x, coerce = FALSE, x_name = substitute(x), error = TRUE)

check_probability(x, coerce = FALSE, x_name = substitute(x),
  error = TRUE)

check_prop(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce an integer to a dbl and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a probability (non-missing dbl between 0 and 1 inclusive with no attributes including names).
}
\examples{
check_prob(1, error = FALSE)
check_prob(1.1, error = FALSE)
check_prob(c(0, 1), error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
