% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing-names.R
\name{check_missing_names}
\alias{check_missing_names}
\title{Check Missing Names}
\usage{
check_missing_names(x, names, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The named object to check.}

\item{names}{A character vector of the names that must be missing from x.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether specific names are missing from an object.
}
\examples{
vec <- c(x = 1, y = 2, z = 0)
check_missing_names(vec, c("y", "x", "a"), error = FALSE)
check_missing_names(vec, "a", error = FALSE)
}
\seealso{
\code{\link{check_names}}
}
