% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSetEqual.r
\name{checkSetEqual}
\alias{assertSetEqual}
\alias{assert_set_equal}
\alias{checkSetEqual}
\alias{expect_set_equal}
\alias{testSetEqual}
\alias{test_set_equal}
\title{Check if object is a subset of a given set}
\usage{
checkSetEqual(x, y, ordered = FALSE)

assertSetEqual(x, y, ordered = FALSE, add = NULL, .var.name)

assert_set_equal(x, y, ordered = FALSE, add = NULL, .var.name)

testSetEqual(x, y, ordered = FALSE)

test_set_equal(x, y, ordered = FALSE)

expect_set_equal(x, y, ordered = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{y}{[\code{atomic}]\cr
Set to compare with.}

\item{ordered}{[\code{logical(1)}]\cr
Check \code{x} to have the same length and order as \code{y}, i.e.
check using \dQuote{==} while handling \code{NA}s nicely.
Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertSubset}/\code{assert_subset}
 throws an error message, \code{testSubset}/\code{test_subset}
 returns \code{FALSE},
 and \code{checkSubset} returns a string with the error message.
 The function \code{expect_subset} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if object is a subset of a given set
}
\examples{
 testSetEqual(c("a", "b"), c("a", "b"))
 testSetEqual(1:3, 1:4)
}
\seealso{
Other set: \code{\link{checkChoice}},
  \code{\link{checkSubset}}
}

