% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolant.R
\name{interpolant}
\alias{interpolant}
\title{Evaluate an interpolant in a point}
\arguments{
\item{x}{The argument of the function. A function of more then one variable takes a
vector. \code{x} can also be a matrix of column vectors.}

\item{threads}{The number of threads to use for evaluation. All  interpolants created by
\pkg{chebpol} are parallelized. If given a matrix argument \code{x}, the vectors can
be evaluated in parallel.}

\item{...}{Other parameters. Currently used for simplex linear interpolants with the logical argument
\code{epol} which makes the interpolant extrapolate to points outside the domain.
The stalker spline has two such arguments: \code{degree} is the degree if
different from the one at creation time. It can be a vector, one degree for each dimension.
\code{blend=c("linear","cubic","sigmoid")} is
a blending function as described in a vignette.}
}
\value{
A numeric. If more than one point was evaluated, a vector.
}
\description{
An interpolant is a function returned by \code{\link{ipol}} which has prespecified values in some
points, and which fills in between with some reasonable values.
}
\examples{
grid <- list(x=seq(0,1,length.out=10), y=seq(0,1,length.out=10))
val <- runif(100)
dim(val) <- c(10,10)
ip <- ipol(val, grid=grid, method='fh')
ip(c(0.3, 0.8))
ip(matrix(runif(12),2), threads=2)
}
