% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt2img_StableDiffusion4R.R
\name{txt2img_StableDiffusion4R}
\alias{txt2img_StableDiffusion4R}
\title{Text-to-image generator using Stable Diffusion}
\usage{
txt2img_StableDiffusion4R(
  text_prompts = "",
  negative_prompts = "text, low quality, noisy, blurry",
  weight = 0.5,
  height = 512,
  width = 512,
  number_of_images = 3,
  steps = 10,
  cfg_scale = 7,
  clip_guidance_preset = "NONE",
  sampler = NULL,
  style_preset = "photographic",
  engine_id = "stable-diffusion-512-v2-1",
  api_host = "https://api.stability.ai",
  api_key = Sys.getenv("DreamStudio_API_KEY"),
  verbose = TRUE
)
}
\arguments{
\item{text_prompts}{A string. The text prompt to use for image generation. Should not be empty.}

\item{negative_prompts}{A string. The negative prompts for image generation.}

\item{weight}{A numeric value indicating the weight of the text prompt. Default is 0.5.}

\item{height}{An integer. The height of the image in pixels. Default is 512.}

\item{width}{An integer. The width of the image in pixels. Default is 512.}

\item{number_of_images}{An integer. The number of images to generate. Default is 3.}

\item{steps}{An integer. The number of diffusion steps to run. Default is 10.}

\item{cfg_scale}{A numeric value. How strictly the diffusion process adheres to the prompt text. Default is 7.}

\item{clip_guidance_preset}{A string. A preset to guide the image model. Default is 'NONE'.}

\item{sampler}{A string. Which sampler to use for the diffusion process. If this value is omitted we'll automatically select an appropriate sampler for you. Possible values are 'DDIM', 'DDPM', 'K_DPMPP_2M', 'K_DPMPP_2S_ANCESTRAL', 'K_DPM_2', 'K_DPM_2_ANCESTRAL', 'K_EULER', 'K_EULER_ANCESTRAL', 'K_HEUN', 'K_LMS'. Default is NULL.}

\item{style_preset}{A string. A style preset to guide the image model towards a particular style. Default is 'photographic'. Some possible values are: '3d-model', 'analog-film', 'anime', 'cinematic', 'comic-book', 'digital-art', 'enhance', 'fantasy-art', 'isometric', 'line-art', 'low-poly', 'modeling-compound', 'neon-punk', 'origami', 'photographic', 'pixel-art', 'tile-texture'.}

\item{engine_id}{A string. The engine id to be used in the API. Default is 'stable-diffusion-512-v2-1'.
Other possible values are 'stable-diffusion-v1-5', 'stable-diffusion-xl-beta-v2-2-2', 'stable-diffusion-768-v2-1'.}

\item{api_host}{A string. The host of the Stable Diffusion API. Default is 'https://api.stability.ai'.}

\item{api_key}{A string. The API key for the Stable Diffusion API. It is read from the 'DreamStudio_API_KEY' environment variable by default.}

\item{verbose}{A logical flag to print the message Default is TRUE.}
}
\value{
A list of images generated from the text prompt.
}
\description{
This function Generate an image from a text prompt using the Stable Diffusion API.
             It sends the parameters to the API and receives a response that includes
             the base64-encoded image data, which is then converted to a PNG image.
}
\examples{
\dontrun{
Sys.setenv(DreamStudio_API_KEY = "Your API key")
text_prompts = "japanese castle"
images = txt2img_StableDiffusion4R(text_prompts)
Display(images)
}
}
\author{
Satoshi Kume
}
