% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextSummary.R
\name{TextSummary}
\alias{TextSummary}
\title{Summarize Long Text}
\usage{
TextSummary(
  text = clipr::read_clip(),
  nch = 1000,
  Summary_block = 200,
  Model = "gpt-3.5-turbo",
  temperature = 1,
  language = "English",
  verbose = TRUE
)
}
\arguments{
\item{text}{A character vector containing the text to be summarized.
If not provided, the function will attempt to read from the clipboard.}

\item{nch}{Integer specifying the number of characters at which to split the input text for processing.}

\item{Summary_block}{Integer specifying the target number of characters for the summarized output.}

\item{Model}{A character string specifying the AI model to be used for text summarization. Default is "gpt-3.5-turbo".}

\item{temperature}{Numeric specifying the randomness of the AI model's output.}

\item{language}{A character string specifying the language in which the summary should be generated. Default is "English".}

\item{verbose}{A logical flag to print the message Default is TRUE.}
}
\value{
A list of character vectors where each vector is a part of the summarized text.
}
\description{
This function summarizes a long text using an AI model.
This is an experimental function.
}
\details{
Summarize Long Text
}
\examples{
\dontrun{
TextSummary(text = c("This is a long text to be summarized.",
                     "It spans multiple sentences and goes into much detail."),
            nch = 1000, Summary_block = 100,
            Model = "gpt-3.5-turbo", temperature = 1, language = "English")
}
}
\author{
Satoshi Kume
}
