% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{WBS.network}
\alias{WBS.network}
\title{Wild binary segmentation for network change points detection.}
\usage{
WBS.network(data_mat1, data_mat2, s, e, Alpha, Beta, delta, level = 0)
}
\arguments{
\item{data_mat1}{A \code{numeric} matrix of observations with with horizontal axis being time, and with each column be the vectorized adjacency matrix.}

\item{data_mat2}{An independent copy of data_mat1.}

\item{s}{A \code{integer} scalar of starting index.}

\item{e}{A \code{integer} scalar of ending index.}

\item{Alpha}{A \code{integer} vector of starting indices of random intervals.}

\item{Beta}{A \code{integer} vector of ending indices of random intervals.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}

\item{level}{Should be fixed as 0.}
}
\value{
An object of \code{\link[base]{class}} "BS", which is a \code{list} with the following structure:
 \item{S}{A vector of estimated change points (sorted in strictly increasing order).}
 \item{Dval}{A vector of values of CUSUM statistic based on KS distance.}
 \item{Level}{A vector representing the levels at which each change point is detected.}
 \item{Parent}{A matrix with the starting indices on the first row and the ending indices on the second row.}
}
\description{
Perform wild binary segmentation for network change points detection.
}
\examples{
p = 15 # number of nodes
rho = 0.5 # sparsity parameter
block_num = 3 # number of groups for SBM
n = 100 # sample size for each segment
# connectivity matrix for the first and the third segments
conn1_mat = rho * matrix(c(0.6,1,0.6,1,0.6,0.5,0.6,0.5,0.6), nrow = 3) 
# connectivity matrix for the second segment
conn2_mat = rho * matrix(c(0.6,0.5,0.6,0.5,0.6,1,0.6,1,0.6), nrow = 3) 
set.seed(1)
can_vec = sample(1:p, replace = FALSE) # randomly assign nodes into groups
sbm1 = simu.SBM(conn1_mat, can_vec, n, symm = TRUE, self = TRUE)
sbm2 = simu.SBM(conn2_mat, can_vec, n, symm = TRUE, self = TRUE)
data_mat = cbind(sbm1$obs_mat, sbm2$obs_mat)
data_mat1 = data_mat[,seq(1,ncol(data_mat),2)]
data_mat2 = data_mat[,seq(2,ncol(data_mat),2)]
M = 10
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(data_mat1))
temp = WBS.network(data_mat1, data_mat2, 1, ncol(data_mat1), 
                   intervals$Alpha, intervals$Beta, delta = 5)
rho_hat = quantile(rowMeans(data_mat), 0.95)
tau = p*rho_hat*(log(n))^2/20 # default threshold given in the paper
cpt_init = unlist(thresholdBS(temp, tau)$cpt_hat[,1])
cpt_refined = local.refine.network(cpt_init, data_mat1, data_mat2, 
                      self = TRUE, tau2 = p*rho_hat/3, tau3 = Inf)
cpt_WBS = 2*cpt_init
cpt_refined = 2*cpt_refined
}
\references{
Wang, Yu and Rinaldo (2018) <arxiv:1809.09602>.
}
\seealso{
\code{\link{thresholdBS}} for obtaining change points estimation.
}
\author{
Daren Wang & Haotian Xu
}
