% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{CV.search.DP.LR.regression}
\alias{CV.search.DP.LR.regression}
\title{Grid search based on Cross-Validation of all tuning parameters (gamma, lambda and zeta) for regression.}
\usage{
CV.search.DP.LR.regression(
  y,
  X,
  gamma_set,
  lambda_set,
  zeta_set,
  delta,
  eps = 0.001
)
}
\arguments{
\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with horizontal axis being time.}

\item{gamma_set}{A \code{numeric} vector of candidate tuning parameter associated with the l0 penalty.}

\item{lambda_set}{A \code{numeric} vector of candidate tuning parameter for the lasso penalty.}

\item{zeta_set}{A \code{numeric} vector of candidate tuning parameter for the group lasso.}

\item{delta}{A strictly \code{integer} scalar of minimum spacing.}

\item{eps}{A \code{numeric} scalar of precision level for convergence of lasso.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{A list of vector of estimated changepoints (sorted in strictly increasing order)}
 \item{K_hat}{A list of scalar of number of estimated changepoints}
 \item{test_error}{A list of vector of testing errors (each row corresponding to each gamma, and each column corresponding to each lambda)}
 \item{train_error}{A list of vector of training errors}
}
\description{
Perform grid search based on Cross-Validation of all tuning parameters (gamma, lambda and zeta)
}
\examples{
set.seed(123)
d0 = 8
p = 15
n = 100
cpt_true = c(30, 70)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
gamma_set = c(0.01, 0.1)
lambda_set = c(0.01, 0.1)
temp = CV.search.DP.regression(y = data$y, X = data$X, gamma_set, lambda_set, delta = 2)
temp$test_error # test error result
# find the indices of gamma_set and lambda_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
gamma_set[min_idx[1]]
lambda_set[min_idx[2]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
zeta_set = c(0.1, 1)
temp_zeta = CV.search.DP.LR.regression(data$y, data$X, gamma_set[min_idx[1]],
                  lambda_set[min_idx[2]], zeta_set, delta = 2, eps = 0.001)
min_zeta_idx = which.min(unlist(temp_zeta$test_error))
cpt_LR = local.refine.regression(cpt_init, data$y, X = data$X, zeta = zeta_set[min_zeta_idx])
Hausdorff.dist(cpt_init, cpt_true)
Hausdorff.dist(cpt_LR, cpt_true)
}
\references{
Rinaldo, Wang, Wen, Willett and Yu (2020) <arxiv:2010.10410>
}
\author{
Daren Wang & Haotian Xu
}
