% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.change.point.copula.BKRS.R
\name{test.change.point.copula.BKRS}
\alias{test.change.point.copula.BKRS}
\title{Function toperform changepoint test for the copula with multiplier bootstrap using for changepoint the new sequential process of Bucher et al (2014)}
\usage{
test.change.point.copula.BKRS(
  x,
  N = 1000,
  n_cores = 2,
  method = "nonseq",
  est = FALSE
)
}
\arguments{
\item{x}{(n x d) matrix of data (observations or pseudo-observations, including residuals), d >=2}

\item{N}{number of multipliers samples to compute the P-value}

\item{n_cores}{number of cores for parallel computing (default = 2)}

\item{method}{'nonseq' (default) or 'seq'}

\item{est}{if TRUE, tau is estimated (default = FALSE)}
}
\value{
\item{CVM}{Cramer-von Mises statistic}

\item{KS}{Kolmogorov-Smirnov statistic}

\item{pvalueCVM}{Pvalue for the Cramer-von Mises statistic}

\item{pvalueKS}{Pvalue for theKolmogorov-Smirnov statistic}

\item{tauCVM}{Estimated changepoint using the Cramer-von Mises statistic}

\item{tauKS}{Estimated changepoint using the Kolmogorov-Smirnov statistic}
}
\description{
This function compute the Cramer-von Mises and Kolmogorov-Smirnov test statistics based on the new sequential process of Bucher et al (2014), using multipliers and parallel computing.
Two methods of bootstrapping are used: non-sequential (fastest) and sequential. Both methods yields basically the same P-valueas.
}
\examples{
x<-matrix(rnorm(100),ncol=2)
out = test.change.point.copula.BKRS(x)



}
\references{
Nasri, B. R. Remillard, B., & Bahraoui, T. (2021). Change-point problems for multivariate time series using pseudo-observations

Bucher, A., Kojadinovic, I., Rohmer, T., & Segers, J. (2014). Detecting changes in cross-sectional dependence in multivariate time series, J. Multiv. Anal., 132, 111--128.
}
\author{
Bouchra R Nasri  and Bruno N Remillard, August 6, 2020
}
