# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

rank_asR <- function(x, decreasing = FALSE) {
    .Call('_changepointGA_rank_asR', PACKAGE = 'changepointGA', x, decreasing)
}

#' Randomly select the chromosome
#'
#' Randomly select the changepoint configuration for population initialization.
#' The selected changepoint configuration represents a changepoint chromosome.
#' The first element of the chromosome represent the number of changepoints
#' and the last non-zero element always equal to the length of time series + 1.
#'
#' @param N The length of time series.
#' @param prange A list object containing the possible range for other
#' pre-defined model parameters, i.e. AR/MA order of ARMA models.
#' @param minDist The minimum length between two adjacent changepoints.
#' @param Pb Same as \code{Pchangepoint}, the probability that a changepoint has occurred.
#' @param mmax The maximum possible number of changepoints in the data set.
#' @param lmax The maximum possible length of the chromosome representation.
#' @return A single changepoint configuration format as above.
#' @export
selectTau <- function(N, prange, minDist, Pb, mmax, lmax) {
    .Call('_changepointGA_selectTau', PACKAGE = 'changepointGA', N, prange, minDist, Pb, mmax, lmax)
}

#' Random population initialization
#'
#' Randomly generate the individuals' chromosomes (changepoint confirgurations)
#' to construct the first generation population.
#'
#' @param popsize An integer represents the number of individual in each
#' population for GA (or subpopulation for IslandGA).
#' @param prange Default is \code{NULL} for only changepoint detection. If
#' \code{prange} is specified as a list object, which contains the range of
#' each model order parameters for order selection (integers). The number of
#' order parameters must be equal to the length of \code{prange}.
#' @param N The length of time series.
#' @param minDist The minimum length between two adjacent changepoints.
#' @param Pb Same as \code{Pchangepoint}, the probability that a changepoint has occurred.
#' @param mmax The maximum possible number of changepoints in the data set.
#' @param lmax The maximum possible length of the chromosome representation.
#' @details
#' The default population initialization uses \code{\link{selectTau}} to
#' select the chromosome for the first generation population. Each column from
#' the produced population matrix represent an chromosome of an individual.
#' The first element of every chromosome represent the number of changepoints
#' and the last non-zero element always equal to the length of time series
#' plus one (N+1).
#' @return A matrix that contains each individual's chromosome.
#' @export
random_population <- function(popsize, prange, N, minDist, Pb, mmax, lmax) {
    .Call('_changepointGA_random_population', PACKAGE = 'changepointGA', popsize, prange, N, minDist, Pb, mmax, lmax)
}

#' Uniform crossover to produce offsprings
#'
#' In uniform crossover, typically, each bit is chosen from either parent with
#' equal probability. Other mixing ratios are sometimes used, resulting in
#' offspring which inherit more genetic information from one parent than the
#' other. In a uniform crossover, we don’t divide the chromosome into segments,
#' rather we treat each gene separately. In this, we essentially flip a coin
#' for each chromosome to decide whether or not it will be included in the
#' off-spring. If model order selection is requested, each child's model order
#' has the equal probability (0.5) from \code{dad} and \code{mom}.
#' @param mom Among two selected individuals, \code{mom} represents the selected
#' chromosome representation with lower fitness function value.
#' @param dad Among two selected individuals, \code{dad} represents the selected
#' chromosome representation with larger fitness function value.
#' @param prange Default value is \code{NULL} for only changepoint detection. If
#' \code{prange} is specified as a list object, which contains the range of
#' each model order parameters for order selection (integers). The number of
#' order parameters must be equal to the length of \code{prange}.
#' @param minDist The required minimum distance between two adjacent changepoints.
#' @param lmax The user specified maximum number of changepoints, by default,
#' as \code{N/2 - 1}.
#' @param N The length of time series.
#' @return The child chromosome that produced from \code{mom} and \code{dad} for
#' next generation.
#' @export
uniformcrossover <- function(mom, dad, prange, minDist, lmax, N) {
    .Call('_changepointGA_uniformcrossover', PACKAGE = 'changepointGA', mom, dad, prange, minDist, lmax, N)
}

#' The default parents selection genetic algorithm operator
#'
#' The genetic algorithm require to select a pair of chromosomes, representing
#' \code{dad} and \code{mom}, for the \code{crossover} operator to
#' produce offspring (individual for next generation). The parents chromosomes
#' are randomly selectd from the initialized population by a linear ranking
#' method according to each individual's fittness in the input argument
#' \code{popFit}. By default, the dad has better fit/smaller fitness function
#' value/larger rank than \code{mom}.
#' @param pop A matrix contains the chromosomes for all individuals. The number of
#' rows is equal to \code{lmax} and the number of columns is equal to the
#' \code{popsize}.
#' @param popFit A vector contains the objective function value (population fit)
#' being associated to each individual chromosome from above.
#' @return A list contains the chromosomes for \code{dad} and \code{mom}.
#' @export
selection_linearrank <- function(pop, popFit) {
    .Call('_changepointGA_selection_linearrank', PACKAGE = 'changepointGA', pop, popFit)
}

