% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_calculation.R
\name{energyDistance}
\alias{energyDistance}
\title{Energy distance between two datasets}
\usage{
energyDistance(x1, y1, x2, y2, l = NULL, alpha = 1)
}
\arguments{
\item{x1}{matrix of first period regressors with variables in columns and observations in rows}

\item{y1}{matrix of first period responses with variables in columns and observations in rows}

\item{x2}{matrix of second period regressors with variables in columns and observations in rows}

\item{y2}{matrix of second period responses with variables in columns and observations in rows}

\item{l}{approximate number of contributing variables (default: overall number of regressors)}

\item{alpha}{parameter for energy distance formula (default: `1`)}
}
\value{
energy distance value
}
\description{
Estimate energy distance which is a metric that measures the distance between the distributions
of random vectors \insertCite{rizzo-szekely10}{changedetection}.
The energy distance is zero if an only if the distributions are identical,
otherwise it will diverge.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

ed <- energyDistance(x1=as.data.frame(x[1:30]),
                     y1=as.data.frame(y[1:30]),
                     x2=as.data.frame(x[31:T]),
                     y2=as.data.frame(y[31:T]))

}
\references{
\insertAllCited
}
