% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnelplot.R
\name{funnelplot}
\alias{funnelplot}
\title{Risk-adjusted funnel plot}
\usage{
funnelplot(data, ctime, p0, glmmod, followup, conflev = c(0.95, 0.99))
}
\arguments{
\item{data}{\code{data.frame} containing the following named columns:
\itemize{
\item \code{entrytime} numeric - time of entry into study,
\item \code{survtime} numeric - time from entry until event,
\item \code{censorid} integer - (optional) censoring indicator (0 = right censored, 1 = observed),
\item \code{instance} integer or character - indicating which instance (f.e. hospital) the observation belongs to
} and optionally additional covariates used for risk-adjustment.}

\item{ctime}{construction time at which the funnel plot
should be determined. Constructed over whole data when not specified}

\item{p0}{The baseline failure probability at entrytime + followup for individuals.
If not specified, average failure proportion over whole data is used instead.}

\item{glmmod}{a generalized linear regression model as produced by
the function \code{\link[stats:glm]{glm()}}. Standard practice: \cr
\code{glm(as.formula(paste("(survtime <= followup) & (censorid == 1)~" ,paste(covariates, collapse='+'))), data = data)}. \cr
Alternatively, a list with:
\itemize{
\item $formula (~ covariates)
\item $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and colnames of \code{data}).
}}

\item{followup}{The followup time for every individual. At what time after subject entry do we consider the outcome?}

\item{conflev}{A vector of confidence levels of interest. Default is c(0.95, 0.99).}
}
\value{
An object of class "funnelplot" containing:
\itemize{
\item \code{data}: A \code{data.frame} containing:
\itemize{
\item $instance instance number
\item $observed observed number of failures at instance
\item $expected expected (risk-adjusted) number of failures at instance
\item $numtotal total number of individuals considered at this instance
\item $p (risk-adjusted) proportion of failure at instance
\item $conflevels worse/normal/better performance than expected at this confidence level
}
\item \code{call}: the call used to obtain output
\item \code{plotdata}: data used for plotting confidence intervals
\item \code{conflev}: specified confidence level(s)
}There are \code{\link[cgrcusum:plot.funnelplot]{plot}} and
\code{\link[cgrcusum:summary.funnelplot]{summary}} methods for "funnelplot" objects.
}
\description{
This function can be used to construct a risk-adjusted funnel plot.
}
\examples{
varsanalysis <- c("age", "sex", "BMI")
exprfitfunnel <- as.formula(paste("(entrytime <= 365) & (censorid == 1)~",
 paste(varsanalysis, collapse='+')))
surgerydat$instance <- surgerydat$Hosp_num
glmmodfun <- glm(exprfitfunnel, data = surgerydat, family = binomial(link = "logit"))
funnel <- funnelplot(data = surgerydat, ctime = 3*365, glmmod = glmmodfun, followup = 100)
plot(funnel)
}
\seealso{
\code{\link[cgrcusum]{plot.funnelplot}}, \code{\link[cgrcusum]{summary.funnelplot}}

Other qcchart: 
\code{\link{bercusum}()},
\code{\link{bkcusum}()},
\code{\link{cgrcusum}()}
}
\author{
Daniel Gomon
}
\concept{qcchart}
