% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr_helper.R
\name{cgr_helper}
\alias{cgr_helper}
\title{Continuous time Generalized Rapid response CUSUM (CGR-CUSUM) helper -
single time point}
\usage{
cgr_helper(data, ctime, coxphmod, cbaseh, displaypb = FALSE)
}
\arguments{
\item{data}{data frame containing the following named columns:
\code{entrytime} (numeric - time of entry into study), \code{survtime}
(numeric - time from entry until event), \code{censorid} (integer - censoring
indicator: 0 - right censored, 1 - observed), \code{cause} (factor - cause of
event - competing risks).}

\item{ctime}{construction time (single) at which the value of the chart
should be determined.}

\item{coxphmod}{a cox proportional hazards regression model as produced by
the function \code{\link[survival:coxph]{coxph}}. Obtained using:
\code{coxph(Surv(survtime, censorid) ~ covariates, data = data)}.
Alternatively, a list with $formula (~ covariates)
and $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and colnames).}

\item{cbaseh}{a function which returns the non risk-adjusted cumulative
baseline hazard \eqn{h_0(t)}. If \code{cbaseh} is missing but
\code{coxphmod} has been
specified as a survival object, this baseline hazard rate will be determined
using the provided \code{coxphmod}.}

\item{displaypb}{(optional) boolean indicating whether a progress bar should be
displayed}
}
\value{
A list containing the following:
\itemize{
\item $val value of CGR-CUSUM at specified time point
\item $theta value at corresponding time of the MLE \eqn{\hat{\theta}_t}
\item $starttime time from which individuals contribute to the chart \eqn{S_\nu}
}
}
\description{
This function calculates the value of the CGR-CUSUM at one
specified timepoint
}
\examples{
#TO-DO
}
\seealso{
\code{\link{bkcusum}},
\code{\link{bercusum}} (step 2)
}
\author{
Daniel Gomon
}
