% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg_input}
\alias{cg_input}
\title{Add Input}
\arguments{
\item{value}{numeric vector or array, value of the node (optional).}

\item{name}{character scalar, name of the node (optional). In case argument \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg_node, input.
}
\description{
Add an input node to the graph.
}
\details{
\code{$input(value = NULL, name = NULL)}
}
\note{
The intended use of inputs is that they are not given a fixed value but behave as placeholders. Values can be supplied for inputs when evaluating or differentiating a graph (see \link[cgraph]{cg_run} and \link[cgraph]{cg_gradients} for more details).

There is a wrapper function \link[cgraph]{input} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add an input with name 'x' to the graph.
x$input(name = "x")

}
\author{
Ron Triepels
}
