% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-bibtex.R
\name{encoded_utf_to_latex}
\alias{encoded_utf_to_latex}
\title{Encode UTF-8 text to LaTeX}
\usage{
encoded_utf_to_latex(x)
}
\arguments{
\item{x}{A string, possibly encoded in UTF-8 encoding system.}
}
\value{
A string with the corresponding transformations.
}
\description{
Transform a UTF-8 string to LaTeX special characters.
}
\details{
This is a variation of \code{\link[tools:encoded]{tools::encoded_text_to_latex()}} performing some
additional replacements to increase compatibility.
}
\examples{
\dontshow{if (getRversion() >= "4.0.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Full range of supported characters on R
library(tools)

range <- 1:511

ascii_table <- data.frame(
  dec = range,
  utf8 = intToUtf8(range, multiple = TRUE)
)

# Add latex using base approach
ascii_table$latex_base <- encoded_text_to_latex(ascii_table$utf8,
  encoding = "UTF-8"
)

# With cffr
ascii_table$latex_cffr <- encoded_utf_to_latex(ascii_table$utf8)

ascii_table
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[tools:encoded]{tools::encoded_text_to_latex()}}

Other bibtex: 
\code{\link{cff_extract_to_bibtex}()},
\code{\link{cff_from_bibtex}()},
\code{\link{cff_to_bibtex}()},
\code{\link{write_bib}()}
}
\concept{bibtex}
\keyword{internal}
