% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{biofam2}
\alias{biofam2}
\title{Family life states from the Swiss Household Panel biographical survey}
\format{
A data.frame containing three columns:
\itemize{
  \item \emph{id} id of individuals (2000 different ids)
  \item \emph{time} age in years where a change occurs
  \item \emph{state} new state.
}
}
\source{
Swiss Household Panel https://forscenter.ch/projects/swiss-household-panel/
}
\usage{
data(biofam2)
}
\description{
2000 16 year-long family life sequences built from the retrospective biographical survey carried out by the Swiss
Household Panel (SHP) in 2002. Data from \code{TraMineR} package.
}
\details{
The biofam2 dataset derives from the biofam dataset from \code{TraMineR} package.
The biofam2 format is adapted to \code{cfda} functions.
The biofam data set was constructed by Müller et al. (2007) from the data of the retrospective biographical survey
carried out by the Swiss Household Panel (SHP) in 2002.
The data set contains sequences of family life states from age 15 to 30 (sequence length is 16).
The sequences are a sample of 2000 sequences of those created from the SHP biographical survey.
It includes only individuals who were at least 30 years old at the time of the survey.
The biofam data set describes family life courses of 2000 individuals born between 1909 and 1972.

The eight states are defined from the combination of five basic states, namely Living with parents (Parent),
Left home (Left), Married (Marr), Having Children (Child), Divorced:
"Parent", "Left", "Married", "Left+Marr", "Child", "Left+Child", "Left+Marr+Child", "Divorced"
}
\examples{
data(biofam2)
head(biofam2)
\donttest{
# It is recommended to increase the number of cores to reduce computation time
set.seed(42)
basis <- create.bspline.basis(c(15, 30), nbasis = 4, norder = 4)
fmca <- compute_optimal_encoding(biofam2, basis, nCores = 2)

plot(fmca, harm = 1)
plot(fmca, harm = 2)
plotEigenvalues(fmca, cumulative = TRUE, normalize = TRUE)
plotComponent(fmca, comp = c(1, 2), addNames = FALSE)
}
}
\references{
Müller, N. S., M. Studer, G. Ritschard (2007). Classification de parcours de vie à l'aide de l'optimal matching.
In XIVe Rencontre de la Société francophone de classification (SFC 2007), Paris, 5 - 7 septembre 2007, pp. 157–160.
}
\seealso{
Other datasets: 
\code{\link{care}},
\code{\link{flours}}
}
\concept{datasets}
\keyword{data}
