% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings}
\alias{cfbd_ratings}
\title{\strong{CFBD Ratings and Rankings Endpoints Overview}}
\description{
\describe{
\item{\code{cfbd_rankings()}:}{ Gets Historical CFB poll rankings at a specific week.}
\item{\code{cfbd_ratings_sp()}:}{ Get SP historical rating data.}
\item{\code{cfbd_ratings_sp_conference()}:}{ Get SP conference-level historical rating data.}
\item{\code{cfbd_ratings_srs()}:}{ Get SRS historical rating data.}
}
\subsection{\strong{Get historical Coaches and AP poll data}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_rankings(year = 2019, week = 12)

cfbd_rankings(year = 2018, week = 14)

cfbd_rankings(year = 2013, season_type = "postseason")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get SP historical rating data}}{

At least one of \strong{year} or \strong{team} must be specified for the function to run

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_ratings_sp(year = 2018)

cfbd_ratings_sp(team = "Texas A&M")

cfbd_ratings_sp(year = 2019, team = "Texas")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get conference level SP historical rating data}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_ratings_sp_conference(year = 2019)

cfbd_ratings_sp_conference(year = 2012, conference = "SEC")

cfbd_ratings_sp_conference(year = 2016, conference = "ACC")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get SRS historical rating data}}{

At least one of \strong{year} or \strong{team} must be specified for the function to run

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_ratings_srs(year = 2019, team = "Texas")

cfbd_ratings_srs(year = 2018, conference = "SEC")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get Elo historical rating data}}{

Acquire the CFBD calculated elo ratings data by \strong{team}, \strong{year}, \strong{week}, and \strong{conference}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_ratings_elo(year = 2019, team = "Texas")

cfbd_ratings_elo(year = 2018, conference = "SEC")
}\if{html}{\out{</div>}}
}
}
