% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ces.R
\name{get_ces}
\alias{get_ces}
\title{Get Canadian Election Study Dataset}
\usage{
get_ces(
  year,
  variant = NULL,
  format = "tibble",
  language = "en",
  clean = TRUE,
  preserve_metadata = TRUE,
  use_cache = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{year}{A character string indicating the year of the CES data.
Available years include "1965", "1968", "1972", "1974", "1984", "1988", "1993",
"1997", "2000", "2004", "2006", "2008", "2011", "2015", "2019", "2021".}

\item{variant}{A character string indicating the survey variant to download.
Options depend on the year: "single_survey" (default for most years), "web" (default for 2015, 2019),
"phone", "combo", "1974_1980", "jnjl", "sep", "nov". Use \code{\link{list_ces_datasets}} to see
available variants for each year.}

\item{format}{A character string indicating the format to return the data in.
Default is "tibble". Options include "tibble", "data.frame", or "raw".}

\item{language}{A character string indicating the language of the survey questions.
Default is "en" (English). Alternative is "fr" (French).}

\item{clean}{Logical indicating whether to clean the data (recode variables,
convert factors, etc.). Default is TRUE.}

\item{preserve_metadata}{Logical indicating whether to prioritize preserving all
variable metadata (labels, attributes) over standardization. Default is TRUE.
This ensures all original question labels and value labels are maintained.}

\item{use_cache}{Logical indicating whether to use cached data if available.
Default is TRUE.}

\item{verbose}{Logical indicating whether to display detailed progress messages
during data retrieval and processing. Default is TRUE.}
}
\value{
A tibble or data.frame containing the requested CES data.
}
\description{
This function downloads and processes a Canadian Election Study dataset for the specified year.
}
\note{
Official PDF codebooks for each CES year are available via the
\code{\link{download_pdf_codebook}} function, which provides detailed information
about variables, question wording, and methodology.
}
\examples{
\donttest{
# Get the 2019 CES web survey data (default)
ces_2019_web <- get_ces("2019")

# Get the 2019 CES phone survey data
ces_2019_phone <- get_ces("2019", variant = "phone")

# Get the 1993 CES data, unprocessed
ces_1993_raw <- get_ces("1993", clean = FALSE)

# Get 1972 September survey
ces_1972_sep <- get_ces("1972", variant = "sep")

# Download the official codebook to temporary directory
download_pdf_codebook("2019", path = tempdir())
}

}
