% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{distanceSteps}
\alias{distanceSteps}
\title{Distance between Two Steps}
\usage{
distanceSteps(X, trackids, t, quietly = FALSE)
}
\arguments{
\item{X}{a tracks object}

\item{trackids}{a vector of two indices specifying the tracks to get steps from.}

\item{t}{the timepoint at which the steps should start.}

\item{quietly}{logical; should a warning be returned if one or both of the steps are missing
in the data and the function returns NA?}
}
\value{
A single distance, or NA if the desired timepoint is missing for one or both
of the tracks.
}
\description{
Compute the distance between two steps in the dataset that occur at the same timepoint.
The distance is the distance between the step starting points.
}
\examples{
## Find the distance between the steps of the tracks with ids 1 and 2, at the 3rd
## timepoint in the dataset.
t <- timePoints( TCells )[3]
distanceSteps( TCells, c("1","2"), t )
}
\seealso{
\code{\link{angleSteps}} to compute the angle between the steps,
\code{\link{timePoints}} to list all timepoints in a dataset,
and \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
