% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize Seahorse data}
\usage{
normalize(seahorse_rates, norm_csv)
}
\arguments{
\item{seahorse_rates}{The seahorse rates table read by the \code{\link[=read_data]{read_data()}}
function.}

\item{norm_csv}{A csv file with the experimental groups in column 1 and cell
count or \eqn{\mu}g of protein in column 2. Headers are ignored.}
}
\value{
a normalzed seahorse_rates data.table
}
\description{
Normalizes input data according to cell number or \eqn{\mu}g of protein. It
assumes your data is background normalized.
}
\details{
This normalization is distinct from the background normalization done by the
Wave software. If the data are not background normalized, \code{read_data()} will
output a warning showing rows with OCR, ECAR and PER values greater than 0.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
norm_csv <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "norm.csv", full.names = TRUE)
read.csv(norm_csv)
seahorse_rates <- read_data(rep_list, sheet = 2)
head(seahorse_rates, n = 10)
seahorse_rates.normalized <- normalize(seahorse_rates, norm_csv)
head(seahorse_rates.normalized, n = 10)
}
