% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthprocr.R
\name{orthprocr}
\alias{orthprocr}
\title{Orthogonal Procrustes Analysis}
\usage{
orthprocr(Z, X)
}
\arguments{
\item{Z}{The target matrix}

\item{X}{The matrix to be rotated, which must be of the same size as Z.}
}
\value{
A list with the following 2 elements: \item{Q}{The rotation matrix}
\item{XQ}{The matrix X after rotation}
}
\description{
Simple function to rotate matrix X so that it matches the target matrix Z as
closely as possible, by minimizing ||Z - XQ|| where Z and X are of the same
size and Q is an orthogonal matrix. The algorithm is based on the singular
value decomposition (SVD) (see e.g. the reference).
}
\references{
Gower, J. C. and Hand, D.J. (1996). Biplots (Vol. 54). CRC Press.
}
