% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrPwlm.R
\name{qrPwlm}
\alias{qrPwlm}
\title{Probability Weighted L-moment Skewness and Kurtosis}
\usage{
qrPwlm(x, n = NULL, mu = NULL, sigma = NULL, fd = NULL, sd = NULL)
}
\arguments{
\item{x}{The vector of values for the calculation of  Skewness and Kurtosis.}

\item{n}{The number of samples drawn in the simulation. The higher this value, the greater accuracy.}

\item{mu}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}
}
\value{
The tau3(skew) and tau4(kurtosis) values of the L-moment.
}
\description{
Calculate the skew and kurtosis statistics based on probability weighted moments, via simulation method.
}
\details{
This function computes the L-moment measures of skew and kurtosis, which may be computed via linear combinations of probability-weighted moments (Greenwood, Landwehr, Matalas and Wallis, 1979).
}
\examples{
qrPwlm(n = 1000, mu = 0.5, sigma = 1, fd = 't2', sd = 't2')
}
\references{
Greenwood, J. A., Landwehr, J. M., Matalas, N. C., & Wallis, J. R. (1979). Probability weighted moments: definition and relation to parameters of several distributions expressable in inverse form. Water Resources Research, 15(5), 1049-1054.
}
