% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{cfa.inner}
\alias{cfa.inner}
\title{cfa.inner}
\usage{
cfa.inner(tvals, yvals, data, yname, tname, xnames = NULL,
  method = "dr", link = "logit", tau = seq(0.01, 0.99, 0.01),
  condDistobj = NULL, se = TRUE, iters = 100, cl = 1)
}
\arguments{
\item{tvals}{the values of the "treatment" to compute parameters of
interest for}

\item{yvals}{the values to compute the counterfactual distribution for}

\item{data}{the data.frame where y, t, and x are}

\item{yname}{the name of the outcome (y) variable}

\item{tname}{the name of the treatment (t) variable}

\item{xnames}{the names of additional control variables to include}

\item{method}{either "dr" or "qr" for distribution regression or quantile regression}

\item{link}{if using distribution regression, any link function that works with the binomial family (e.g. logit (the default), probit, cloglog)}

\item{tau}{if using quantile regression, which values of tau to estimate
the conditional quantiles}

\item{condDistobj}{optional conditional distribution  object that has
been previously  computed}

\item{se}{whether or not to compute standard errors using the bootstrap}

\item{iters}{how many bootstrap iterations to use}

\item{cl}{how many clusters to use for parallel computation of standard
errors}
}
\value{
CFA object
}
\description{
calls function to compute counterfactuals
}
\keyword{internal}
