% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccdrAlgorithm-mvn.R
\name{generate_mvn_data}
\alias{generate_mvn_data}
\title{Generate data from a DAG}
\usage{
generate_mvn_data(graph, params, n = 1, ivn = NULL, ivn.rand = TRUE)
}
\arguments{
\item{graph}{DAG in \code{\link{edgeList}} format.}

\item{params}{Vector of parameters. Last p elements correspond to variances (p = number of nodes in \code{graph}), initial elements correspond to edge weights.}

\item{n}{Number of samples to draw.}

\item{ivn}{List of interventions (see \code{\link[sparsebnUtils]{sparsebnData}}). Must be a \code{list} with exactly \code{n} components.}

\item{ivn.rand}{If \code{TRUE}, random N(0,1) values will be drawn for each intervention. Otherwise, these values need to supplied manually in \code{ivn}.}
}
\description{
Given a Gaussian DAG, generate data from the underlying distribution.
Equivalently, generate data from a multivariate normal distribution given
one of its SEM. Can generate both observational and intervention data.
}
\details{
If \code{ivn = NULL}, then \code{n} observational samples are drawn. For each
component of \code{ivn} that is not \code{NULL}, interventional samples will
be drawn with the values of each node specified in the component.
}
\examples{

### Generate observational data
gr <- sparsebnUtils::random.graph(5, 5) # use sparsebnUtils package to generate a random graph
gr.params <- runif(10) # there are 5 coefficients + 5 variances
data.obs <- ccdrAlgorithm::generate_mvn_data(graph = gr,
                                             n = 100,
                                             params = gr.params)

### Generate experimental data
ivn <- as.list(c(rep("V1", 50), rep("V2", 50))) # 50 interventions on V1, 50 interventions on V2
data.ivn <- ccdrAlgorithm::generate_mvn_data(graph = gr,
                                             n = 100,
                                             params = gr.params,
                                             ivn = ivn)

### Use pre-specified values for interventions
###  In this toy example, we assume that all intervened nodes were fixed to
###  to the value 1, although this can be any number of course.
ivn.vals <- lapply(ivn, function(x) sapply(x, function(x) 1)) # replace all entries with a 1
data.ivn <- ccdrAlgorithm::generate_mvn_data(graph = gr,
                                             n = 100,
                                             params = gr.params,
                                             ivn = ivn.vals,
                                             ivn.rand = FALSE)

### If ivn.rand = FALSE, you must specify values
###  The code below will fail because ivn does not contain any values
### (compare to ivn.vals above).
\dontrun{
data.ivn <- ccdrAlgorithm::generate_mvn_data(graph = gr,
                                             n = 100,
                                             params = gr.params,
                                             ivn = ivn,
                                             ivn.rand = FALSE)
}

}
