% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permut.R
\name{permut}
\alias{permut}
\title{Permutation test when \code{dist_permutations} is specified}
\usage{
permut(
  Y,
  X,
  Z = NULL,
  distance = "L2",
  n_perm,
  method = "logistic regression",
  parallel = TRUE,
  n_cpus = NULL,
  fast = TRUE
)
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expressions from \code{n} samples (or cells).}

\item{X}{a data frame containing numeric or factor vector(s) of size \code{n}
containing the variable(s) to be tested (the condition(s) to be tested).}

\item{Z}{a data frame containing numeric or factor vector(s) of size \code{n}
containing the covariate(s).}

\item{method}{a character string indicating which method to use to
compute the CCDF, either \code{'linear regression'}, \code{'logistic regression'}
and  \code{'permutations'} or \code{'RF'} for Random Forests.
Default is \code{'linear regression'} since it is the method used in the test.

#'@param parallel a logical flag indicating whether parallel computation
should be enabled. Default is \code{TRUE}.}

\item{n_cpus}{an integer indicating the number of cores to be used when
\code{parallel} is \code{TRUE}.
Default is \code{parallel::detectCores() - 1}.}

\item{fast}{a logical flag indicating whether the fast implementation of
logistic regression should be used. Only if \code{'dist_permutations'} is specified.
Default is \code{TRUE}.}
}
\value{
A data frame with the following elements:
\itemize{
  \item \code{score} contains the test statistic for a given gene.
  \item \code{pval} contains the raw p-values for a given gene computed from \code{n_perm} permutations.
}
}
\description{
Permutation test when \code{dist_permutations} is specified
}
\examples{

if(interactive()){
X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
permut(Y,X,method="linear regression",n_perm=10,n_cpus=2)}
}
\keyword{internal}
