% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs.R
\name{get_human_hazard_by_dtxsid}
\alias{get_human_hazard_by_dtxsid}
\title{Get human hazard data by DTXSID}
\usage{
get_human_hazard_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing chemical human hazard data
}
\description{
Get human hazard data by DTXSID
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull human hazard data for BPA
bpa_human <- get_human_hazard_by_dtxsid(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
