% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_mol_batch}
\alias{get_chemical_mol_batch}
\title{Get mol file by DTXSID or DTXCID batch}
\usage{
get_chemical_mol_batch(
  DTXSID = NULL,
  DTXCID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of the chemical identifier DTXSIDs.}

\item{DTXCID}{A list of the chemical identifier DTXCIDs.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of character strings giving a mol file representations
of the given input chemicals.
}
\description{
Get mol file by DTXSID or DTXCID batch
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull mol files for multiple chemicals by DTXSID
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
mol_files <- get_chemical_mol_batch(DTXSID = dtxsid)
# Pull mol files for multiple chemicals by DTXCID
dtxcid <- c('DTXCID30182', 'DTXCID001315')
mol_files <- get_chemical_mol_batch(DTXCID = dtxcid)
\dontshow{\}) # examplesIf}
}
