% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-table-list.R
\name{get_table_list}
\alias{get_table_list}
\title{Retrieve a data.frame with requested cbs tables}
\usage{
get_table_list(..., select = NULL,
  base_url = getOption("cbsodataR.base_url", BASE_URL))
}
\arguments{
\item{...}{filter statement to select rows, e.g. Language="nl"}

\item{select}{\code{character} columns to be returned, by default all columns
will be returned.}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocal.}
}
\value{
\code{data.frame} with identifiers, titles and descriptions of tables
}
\description{
\code{get_table_list} by default a list of all tables and all columns will be retrieved.
You can restrict the query by supplying multiple filter statements or by specifying the
columns that should be returned.
}
\note{
\code{get_table_list} will cache results, so subsequent calls will be much faster.
}
\examples{
\dontrun{

# get list of english tables
tables_en <- get_table_list(Language="en")

# get list of dutch tables
tables_nl <- get_table_list(Language="nl")
View(tables_nl)
}
}
