% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{estimate_effect}
\alias{estimate_effect}
\title{Estimate treatment effects}
\usage{
estimate_effect(
  data,
  formula = NULL,
  weights,
  hajek = TRUE,
  doubly.robust = TRUE,
  matched = FALSE,
  estimand = c("ATT", "ATC", "ATE", "feasible"),
  model = NULL,
  split.model = TRUE,
  sample_weight = NULL,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame}, a \code{list}, or a \link[=DataSim]{DataSim} object}

\item{formula}{the outcome model formula}

\item{weights}{An object of class \link[=causalWeights-class]{causalWeights}}

\item{hajek}{Should the weights be normalized to sum to 1 (TRUE/FALSE)}

\item{doubly.robust}{Should an augmented estimator be used? (TRUE/FALSE)}

\item{matched}{Should a matched or barycentric project
estimator be used? (TRUE/FALSE)}

\item{estimand}{Estimand to use. Should agree with estimand in the weights or can
be left blank. One of "ATT", "ATC", or "ATE".}

\item{model}{The outcome model as a character referring to a function or function}

\item{split.model}{Should the outcome model be calculated separately in each
treatment group? (TRUE/FALSE)}

\item{sample_weight}{The sample weights. Either NULL or an object of class
\link[=sampleWeights-class]{sampleWeights}}

\item{...}{Pass additional arguments to the outcome modeling functions like \code{lm}. Arguments "balance.covariates" and "treatment.indicator" must be provided if data is of class data.frame or matrix.}
}
\value{
an object of class \link[=causalEffect-class]{causalEffect}
}
\description{
Estimate treatment effects
}
\examples{
# set-up data
data <- Hainmueller$new()
data$gen_data()

# calculate quantities
weight <- calc_weight(data, method = "Logistic")
tx_eff <- estimate_effect(data = data, weights = weight)

# get estimate
print(tx_eff$estimate)
}
