% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTraitCauchy.R
\name{rTraitCauchy}
\alias{rTraitCauchy}
\title{Cauchy Trait Simulation}
\usage{
rTraitCauchy(
  n = 1,
  phy,
  model = c("cauchy", "lambda", "kappa", "delta"),
  parameters = NULL
)
}
\arguments{
\item{n}{number of independent replicates}

\item{phy}{a phylogeny in \code{\link{ape}} \code{\link[ape]{phylo}} format.}

\item{model}{a phylogenetic model. Default is "cauchy", for the Cauchy process. Alternative are "lambda", "kappa", and "delta".}

\item{parameters}{list of parameters for the model (see Details).}
}
\value{
If n=1, a numeric vector with names from the tip labels in the tree.
For more than 1 replicate, a matrix with the tip labels as row names, and one column per replicate.
}
\description{
Simulate a continuous trait using the Cauchy Process
}
\details{
The default choice of parameters is as follow:
\describe{
  \item{\code{model = cauchy}}{ 
  \code{root.value = 0}, \code{disp = 1}
  }
  \item{\code{model = lambda}}{ 
  \code{root.value = 0}, \code{disp = 1}, \code{lambda = 1}
  }
  \item{\code{model = kappa}}{ 
  \code{root.value = 0}, \code{disp = 1}, \code{kappa = 1}
  }
  \item{\code{model = delta}}{ 
  \code{root.value = 0}, \code{disp = 1}, \code{delta = 1}
  }
}
}
\examples{
set.seed(1289)
phy <- ape::rphylo(40, 0.01, 0)
# One trait
y <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                  parameters = list(root.value = 0, disp = 0.1))
y
plot(phy, x.lim = c(0, 750))
phydataplot(y, phy, offset = 150)
# Many trait
y <- rTraitCauchy(n = 10, phy = phy, model = "cauchy",
                  parameters = list(root.value = 0, disp = 0.1))
head(y)


}
\seealso{
\code{\link[phylolm]{rTrait}}, \code{\link[ape]{rTraitCont}}
}
