% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{caugi_verbs}
\alias{caugi_verbs}
\alias{add_edges}
\alias{remove_edges}
\alias{set_edges}
\alias{add_nodes}
\alias{remove_nodes}
\title{Manipulate nodes and edges of a \code{caugi}}
\usage{
add_edges(cg, ..., from = NULL, edge = NULL, to = NULL, inplace = FALSE)

remove_edges(cg, ..., from = NULL, edge = NULL, to = NULL, inplace = FALSE)

set_edges(cg, ..., from = NULL, edge = NULL, to = NULL, inplace = FALSE)

add_nodes(cg, ..., name = NULL, inplace = FALSE)

remove_nodes(cg, ..., name = NULL, inplace = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{...}{Expressions specifying edges to add using the infix operators,
or nodes to add using unquoted names, vectors via \code{c()}, or \code{+} composition.}

\item{from}{Character vector of source node names. Default is \code{NULL}.}

\item{edge}{Character vector of edge types. Default is \code{NULL}.}

\item{to}{Character vector of target node names. Default is \code{NULL}.}

\item{inplace}{Logical, whether to modify the graph inplace or not.
If \code{FALSE} (default), a copy of the \code{caugi} is made and modified.}

\item{name}{Character vector of node names. Default is \code{NULL}.}
}
\value{
The updated \code{caugi}.
}
\description{
Add, remove, or and set nodes or edges to / from a \code{caugi}
object. Edges can be specified using expressions with the infix operators.
Alternatively, the edges to be added are specified using the
\code{from}, \code{edge}, and \code{to} arguments.
}
\details{
Caugi graph verbs
}
\section{Functions}{
\itemize{
\item \code{add_edges()}: Add edges.

\item \code{remove_edges()}: Remove edges.

\item \code{set_edges()}: Set edge type for given pair(s).

\item \code{add_nodes()}: Add nodes.

\item \code{remove_nodes()}: Remove nodes.

}}
\examples{
# initialize empty graph and build slowly
cg <- caugi(class = "PDAG")

cg <- cg |>
  add_nodes(c("A", "B", "C", "D", "E")) |> # A, B, C, D, E
  add_edges(A \%-->\% B \%-->\% C) |> # A --> B --> C, D, E
  set_edges(B \%---\% C) # A --> B --- C, D, E

cg <- remove_edges(cg, B \%---\% C) |> # A --> B, C, D, E
  remove_nodes(c("C", "D", "E")) # A --> B

# verbs do not build the Rust backend
cg@built # FALSE
build(cg)
cg@built # TRUE

}
\seealso{
Other verbs: 
\code{\link{build}()}
}
\concept{verbs}
