% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/adjust_functions.R
\name{adjust.latent}
\alias{adjust.latent}
\title{Adjust for latent factors, after rotationn}
\usage{
adjust.latent(corr.margin, n, X.cov, Gamma, Sigma, method = c("rr", "nc",
  "lqs"), psi = psi.huber, nc = NULL, nc.var.correction = TRUE)
}
\arguments{
\item{corr.margin}{marginal correlations, p*d1 matrix}

\item{n}{sample size}

\item{X.cov}{estimated second moment of X, d*d matrix}

\item{Gamma}{estimated confounding effects, p*r matrix}

\item{Sigma}{diagonal of the estimated noise covariance, p*1 vector}

\item{method}{adjustment method}

\item{psi}{derivative of the loss function in robust regression, choices are
\code{psi.huber}, \code{psi.bisquare}and \code{psi.hampel}}

\item{nc}{position of the negative controls}

\item{nc.var.correction}{correct asymptotic variance based on our formula}
}
\value{
a list of objects
\describe{
\item{alpha}{estimated alpha, r*d1 matrix}
\item{beta}{estimated beta, p*d1 matrix}
\item{beta.cov.row}{estimated row covariance of \code{beta}, a length p vector}
\item{beta.cov.col}{estimated column covariance of \code{beta}, a d1*d1 matrix}
}
}
\description{
Adjust for latent factors, after rotationn
}
\details{
The function essentially runs a regression of \code{corr.margin} ~ \code{Gamma}.
The sample size \code{n} is needed to have the right scale.

This function should only be called if you know what you are doing.
Most of the time you want to use the main function \code{\link{cate}} to adjust for confounders.
}
\seealso{
\code{\link{cate}}
}

