% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate the accuracy of multiple (candidate) classifiers in several subgroups}
\usage{
evaluate(
  data,
  contrast = define_contrast("raw"),
  benchmark = 0.75,
  alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  adjustment = c("none", "bonferroni", "maxt", "bootstrap", "mbeta"),
  transformation = c("none", "logit"),
  analysis = c("co-primary", "full"),
  regu = FALSE,
  pars = list(),
  ...
)
}
\arguments{
\item{data}{list of n_g x m binary matrix or data.frame (n_g observations of m binary decisions),
g is the index of subgroups/classes, usually created via \code{\link{compare}}.}

\item{contrast}{\code{cases_contrast} object, specified via \code{\link{define_contrast}}}

\item{benchmark}{value to compare against (RHS), should have same length as data.}

\item{alpha}{numeric, significance level (default: 0.05)}

\item{alternative}{character, specify alternative hypothesis}

\item{adjustment}{character, specify type of statistical adjustment taken to address multiplicity}

\item{transformation}{character, define transformation to ensure results
(e.g. point estimates, confidence limits) lie in unit interval ("none" (default) or "logit")}

\item{analysis}{character, "co-primary" or "full"}

\item{regu}{numeric vector of length 3, specify type of shrinkage.
Alternatively, logical of length one (TRUE := c(2, 1, 1/2), FALSE := c(0, 0, 0))}

\item{pars}{further parameters given as named list list(type="pairs", nboot=10000)}

\item{...}{additional named parameters, can be used instead of (in in conjunction with) \code{pars}}
}
\value{
cases_results object, which is a list of analysis results
}
\description{
Assess classification accuracy of multiple classifcation rules stratified
by subgroups, e.g. in diseased (sensitivity) and healthy (specificity)
individuals.
}
\details{
Adjustment methods (\code{adjustment}) and additional parameters (\code{pars} or \code{...}):\cr

\strong{"none"} (default): no adjustment for multiplicity\cr

\strong{"bonferroni"}: Bonferroni adjustment\cr

\strong{"maxt"}: maxT adjustment\cr

\strong{"bootstrap"}: Bootstrap approach
\itemize{
\item type: "pairs" (default) or "wild" = type (for adjustment="bootstrap)
\item nboot: number of bootstrap draws (default: 5000)
\item res_tra: = 0,1,2 or 3 = type of residual transformation of wild boostrap (default = 0: no transformation)
(see https://www.math.kth.se/matstat/gru/sf2930/papers/wild.bootstrap.pdf)
}

\strong{"mbeta"}: A heuristic Bayesian approach which is based on a multivariate beta-binomial model.
\itemize{
\item nrep: number of posterior draws (default: 5000)
\item lfc_pr: prior probability of 'least-favorable parameter configuration' (default: 1).
}
}
\examples{
#
data <- draw_data_roc()
evaluate(data)
}
