% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazardPlot.R
\name{hazardPlot}
\alias{hazardPlot}
\title{Plot Fitted Hazard Curve as a Function of Time}
\usage{
hazardPlot(
  object,
  newdata,
  type = c("hazard"),
  xlab = NULL,
  breaks = 100,
  ci.lvl = 0.95,
  ylab = NULL,
  line.col = 1,
  ci.col = "grey",
  lty = par("lty"),
  add = FALSE,
  ci = !add,
  rug = !add,
  s = c("lambda.1se", "lambda.min"),
  times = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted object of class \code{glm}, \code{gam}, \code{cv.glmnet} or \code{gbm}. This
is the result from the \code{\link[=fitSmoothHazard]{fitSmoothHazard()}} function.}

\item{newdata}{A data frame in which to look for variables with which to
predict. This is required and must contain all the variables used in the
model. Only one covariate profile can be used. If more than one row is
provided, only the first row will be used.}

\item{type}{Type of plot. Currently, only "hazard" has been implemented.
Default: c("hazard")}

\item{xlab}{x-axis label. Default: the name of the time variable from the
fitted \code{object}.}

\item{breaks}{Number of points at which to estimate the hazard. This argument
is only used if argument \code{times=NULL}. This function will calculate a
sequence of times between the minimum and maximum of observed event times.
Default: 100.}

\item{ci.lvl}{Confidence level. Must be in (0,1), Default: 0.95}

\item{ylab}{y-axis label. Default: NULL which means the function will put
sensible defaults.}

\item{line.col}{Line color, Default: 1. See \code{\link[graphics:par]{graphics::par()}} for details.}

\item{ci.col}{Confidence band color. Only used if argument \code{ci=TRUE},
Default: 'grey'}

\item{lty}{Line type. See \code{\link[graphics:par]{graphics::par()}} for details, Default: par("lty")}

\item{add}{Logical; if TRUE add to an already existing plot; Default: FALSE}

\item{ci}{Logical; if TRUE confidence bands are calculated. Only available
for \code{family="glm"} and \code{family="gam"}, Default: !add}

\item{rug}{Logical. Adds a rug representation (1-d plot) of the event times
(only for \code{status=1}), Default: !add}

\item{s}{Value of the penalty parameter lambda at which predictions are
required (for class \code{cv.glmnet} only). Only the first entry will be
used if more than one numeric value is provided, Default: c("lambda.1se",
"lambda.min")}

\item{times}{Vector of numeric values at which the hazard should be
calculated. Default: NULL which means this function will use the minimum
and maximum of observed event times with the \code{breaks} argument.}

\item{...}{further arguments passed to \code{\link[graphics:matplot]{graphics::matplot()}}}
}
\value{
a plot of the hazard function and a data.frame of original data used
in the fitting along with the data used to create the plots including
\code{predictedhazard} which is the predicted hazard for a given covariate
pattern and time \code{predictedloghazard} is the predicted hazard on the log
scale. \code{lowerbound} and \code{upperbound} are the lower and upper confidence
interval bounds on the hazard scale (i.e. used to plot the confidence
bands). \code{standarderror} is the standard error of the log hazard (only if
\code{family="glm"} or \code{family="gam"})
}
\description{
Visualize estimated hazard curves as a function of time with
confidence intervals. This function takes as input, the result from the
\code{\link[=fitSmoothHazard]{fitSmoothHazard()}} function. The user can also specify a
sequence of times at which to estimate the hazard function. These plots are
useful to visualize the non-proportional hazards, i.e., time dependent
interactions with a covariate.
}
\details{
This is an earlier version of a function to plot hazards. We
recommend instead using the plot method for objects returned by
\code{\link[=fitSmoothHazard]{fitSmoothHazard()}}. See \code{\link[=plot.singleEventCB]{plot.singleEventCB()}}.
}
\examples{
data("simdat")
mod_cb <- fitSmoothHazard(status ~ trt * eventtime,
                                    time = "eventtime",
                                    data = simdat[1:200,],
                                    ratio = 1,
                                    family = "glm")

results0 <- hazardPlot(object = mod_cb, newdata = data.frame(trt = 0),
           ci.lvl = 0.95, ci = FALSE, lty = 1, line.col = 1, lwd = 2)
head(results0)
hazardPlot(object = mod_cb, newdata = data.frame(trt = 1), ci = FALSE,
           ci.lvl = 0.95, add = TRUE, lty = 2, line.col = 2, lwd = 2)
legend("topleft", c("trt=0","trt=1"),lty=1:2,col=1:2,bty="y", lwd = 2)
}
\seealso{
\code{\link[=fitSmoothHazard]{fitSmoothHazard()}}
}
