% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Run Cargo}
\usage{
run(
  ...,
  minimum_version = ".",
  search_methods = c("cache", "convention", "path"),
  leave_no_trace = FALSE,
  environment_variables = list(),
  rustflags = NULL,
  verbose = TRUE,
  stdout = "",
  stderr = ""
)
}
\arguments{
\item{...}{Character vector of command line arguments passed to the
\code{cargo} command.}

\item{minimum_version}{A character string representing the minimum version of
Rust that is needed. Or a path to the root of a package (i.e., the
directory containing the DESCRIPTION file), in which case the value is
found from the field: \code{SystemRequirements: Cargo (>= XXXX)}. For the
\code{search_methods} being \code{"cache"}, the shell command \code{rustup}
is used to upgrade the Cargo installation if needed.}

\item{search_methods}{A character vector potentially containing values
\code{"path"}, \code{"convention"}, and \code{"cache"}. This indicates the
methods to use (and their order) when searching for a suitable Cargo
installation. \code{"path"} indicates to try to use \code{\link[base:Sys.which]{base::Sys.which()}}.
\code{"convention"} indicates to try to use the directories \code{.cargo}
in the user's home directory. \code{"cache"} indicates to try to use the
directory from the cargo package's own installation as given by the
\code{tools::R_user_dir('cargo', 'cache')}.}

\item{leave_no_trace}{If \code{TRUE}, the \code{CARGO_HOME} environment
variable is set to a temporary directory that is subsequently deleted.}

\item{environment_variables}{A named character vector providing environment
variables which should be temporarily set while running Cargo.  Note that
the \code{CARGO_HOME} and \code{RUSTUP_HOME} environment variables are
automatically set when using the \code{"cache"} search method.  Also, the
\code{CARGO_HOME} environment variable is also set when
\code{leave_no_trace == TRUE}.}

\item{rustflags}{A character vector from which the
\code{CARGO_ENCODED_RUSTFLAGS} environment variables is constructed and
then temporarily set. Or, if \code{NULL}, this environment variable is left
unchanged.}

\item{verbose}{If \code{TRUE}, details of the search for Cargo are shown. If
\code{FALSE}, no details are shown.  If it is a connection, then details
are shown and also written to the connection.}

\item{stdout}{See argument of the same name in \code{\link[base:system2]{base::system2()}}.}

\item{stderr}{See argument of the same name in \code{\link[base:system2]{base::system2()}}.}
}
\value{
The same value and behavior as the \code{\link[base:system2]{base::system2()}} function, except
a non-zero exit code will be given in Cargo is not found.
}
\description{
This function runs Cargo (Rust's package manager) with the \code{...}
arguments passed as command line arguments.
}
\examples{
if ( run("--version") != 0 ) {
    message("Cargo is not installed. Please run cargo::install() in an interactive session.")
}

}
