% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shlib.R
\name{shlib_set}
\alias{shlib_set}
\title{Cache a Shared Library}
\usage{
shlib_set(
  pkgname,
  path,
  force = FALSE,
  use_packageStartupMessage = FALSE,
  must_be_silent = FALSE
)
}
\arguments{
\item{pkgname}{A string giving the name of the package.}

\item{path}{A string giving the path to the shared library.}

\item{force}{If \code{TRUE}, installation proceeds without asking for user
confirmation.}

\item{use_packageStartupMessage}{Should essential messages be displayed using
\code{\link[base:message]{base::packageStartupMessage()}}?}

\item{must_be_silent}{Should all messages be suppressed (regardless of the
value of \code{use_packageStartupMessage})?}
}
\value{
A logical indicating whether the library was successfully cached.
}
\description{
This function caches a shared library developed with the Cargo framework.
}
\examples{
shlib_set("my_package","/some/path/to/a/shared_library.so")

}
\seealso{
shlib_get
}
