% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_evaluation.R
\name{co2_eval_cutting}
\alias{co2_eval_cutting}
\title{Fuel Consumption and CO2 Emissions for Cutting}
\usage{
co2_eval_cutting(x, mode = c("standard", "nordic"))
}
\arguments{
\item{x}{An object of class \code{c4c_base_result}}

\item{mode}{Character string to choose between "standard" (default) and
"nordic". For "standard", the function \code{\link{fuel_cons_harvester_1}}
is used. Hoewever, as this function does only provide values for operations
with an average harvest tree diameter of 15 cm and more, the "nordic"
function \code{\link{fuel_cons_harvester_2}} with the option \code{thinning
  = TRUE} is used for smaller average tree sizes.\cr
With the choice "nordic" only the function
\code{\link{fuel_cons_harvester_2}} is used. However, if the harvested
volume per ha per operation amounts to 90\% and more of the standing volume
per ha of the respective stand development phase, which is virutally a
clearcut, the option \code{thinning = FALSE} is used. In case of damage-
induced harvest, only the option \code{thinning = TRUE} is in effect in
order to account for the more difficult conditions of such harvest
operations.}
}
\value{
A data frame (tibble) with the columns time, harvest_type (damage or
regular), phase_no, phase_name (numbers and names of the stand development
phases), fuel_cutting_l_per_m3 (liters of fuel consumed per m3 of
harvested wood), fuel_cutting_total_l (liters of fuel consumed in total),
co2_cutting_total_kg (kg CO2 emitted).
}
\description{
Given the output of a simulation run (i.e. an object of class
\code{c4c_base_result}) as created with the function
\code{\link{simulate_single_concept}}, the fuel consumption and CO2 emissions
for cutting (i.e. felling, limbing, cutting the trees into logs) are
calculated. Currently, this function assumes only harvester operations.
}
\examples{
  base_out <- simulate_single_concept(
   pine_thinning_from_above_1,
   init_areas = c(50, 100, 10, 50, 150, 600),
   time_span  = 50,
   risk_level = 3
  )

  co2_eval_cutting(base_out, "standard")
  co2_eval_cutting(base_out, "nordic")


}
