% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survfit_diff.R
\name{ard_survival_survfit_diff}
\alias{ard_survival_survfit_diff}
\title{ARD Survival Differences}
\usage{
ard_survival_survfit_diff(x, times, conf.level = 0.95)
}
\arguments{
\item{x}{(\code{survift})\cr
object of class \code{'survfit'} typically created with \code{\link[survival:survfit]{survival::survfit()}}}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Calculate differences in the Kaplan-Meier estimator of survival using the
results from \code{\link[survival:survfit]{survival::survfit()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survival", "ggsurvfit")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggsurvfit)
library(survival)

survfit(Surv_CNSR() ~ TRTA, data = cards::ADTTE) |>
  ard_survival_survfit_diff(times = c(25, 50))
\dontshow{\}) # examplesIf}
}
