% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous.R
\name{.lst_results_as_df}
\alias{.lst_results_as_df}
\title{Prepare Results as Data Frame}
\usage{
.lst_results_as_df(x, variable, fun_name)
}
\arguments{
\item{x}{(named \code{list})\cr
the result from \code{\link[=eval_capture_conditions]{eval_capture_conditions()}}}

\item{variable}{(\code{string})\cr
variable name of the results}

\item{fun_name}{(\code{string})\cr
name of function called to get results in \code{x}}
}
\value{
a data frame
}
\description{
Function takes the results from \code{\link[=eval_capture_conditions]{eval_capture_conditions()}}, which is a
named list, e.g. \code{list(result=, warning=, error=)}, and converts it to a data
frame.
}
\examples{
msgs <- eval_capture_conditions({
  warning("Warning 1")
  warning("Warning 2")
  letters[1:2]
})

cards:::.lst_results_as_df(msgs, "result", "mean")
}
\keyword{internal}
