% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_null_statistic.R
\name{replace_null_statistic}
\alias{replace_null_statistic}
\title{Replace NULL Statistics with Specified Value}
\usage{
replace_null_statistic(x, value = NA, rows = TRUE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}

\item{value}{(usually a \code{scalar})\cr
The value to replace \code{NULL} values with. Default is \code{NA}.}

\item{rows}{(\code{\link[rlang:args_data_masking]{data-masking}})\cr
Expression that return a logical value, and are defined in terms of the variables in \code{.data}.
Only rows for which the condition evaluates to \code{TRUE} are replaced.
Default is \code{TRUE}, which applies to all rows.}
}
\value{
an ARD data frame of class 'card'
}
\description{
When a statistical summary function errors, the \code{"statistic"} column will be
\code{NULL}. It is, however, sometimes useful to replace these values with a
non-\code{NULL} value, e.g. \code{NA}.
}
\examples{
# the quantile functions error because the input is character, while the median function returns NA
data.frame(x = rep_len(NA_character_, 10)) |>
  ard_continuous(
    variables = x,
    statistic = ~ continuous_summary_fns(c("median", "p25", "p75"))
  ) |>
  replace_null_statistic(rows = !is.null(error))
}
