# gen_noisedims() works

    Code
      gen_noisedims(n = 500, p = 4, m = c(0, 0, 0, 0), s = c(2, 2, 2, 2))
    Message
      v 4 noise dimensions have been generated successfully!!!
    Output
      # A tibble: 500 x 4
             x1     x2     x3     x4
          <dbl>  <dbl>  <dbl>  <dbl>
       1 -2.64   1.98   2.29  -0.543
       2  1.28  -2.29  -2.56   2.06 
       3  2.58   1.58   2.60  -2.39 
       4 -2.57   0.775 -0.428  4.20 
       5 -0.755 -1.47  -2.52   2.05 
       6  0.308  1.86   2.22   0.980
       7  3.06   0.516  1.25   2.96 
       8 -0.781 -0.472  0.191  1.23 
       9  0.929  0.730  2.60   1.14 
      10 -5.96  -1.26  -2.23   0.355
      # i 490 more rows

# gen_bkgnoise() works

    Code
      gen_bkgnoise(n = 500, p = 4, m = c(0, 0, 0, 0), s = c(2, 2, 2, 2))
    Message
      v Background noise generation completed successfully!!!
    Output
      # A tibble: 500 x 4
             x1     x2     x3     x4
          <dbl>  <dbl>  <dbl>  <dbl>
       1  2.64   1.98  -2.29  -0.543
       2 -1.28  -2.29   2.56   2.06 
       3 -2.58   1.58  -2.60  -2.39 
       4  2.57   0.775  0.428  4.20 
       5  0.755 -1.47   2.52   2.05 
       6 -0.308  1.86  -2.22   0.980
       7 -3.06   0.516 -1.25   2.96 
       8  0.781 -0.472 -0.191  1.23 
       9 -0.929  0.730 -2.60   1.14 
      10  5.96  -1.26   2.23   0.355
      # i 490 more rows

# randomize_rows() works

    Code
      randomize_rows(mobiusgau)
    Output
      # A tibble: 1,000 x 4
              x1     x2       x3       x4
           <dbl>  <dbl>    <dbl>    <dbl>
       1 -0.727  -0.279 -0.182    0.00549
       2  0.469  -0.863 -0.138    0.0171 
       3  0.994  -0.172 -0.0132   0.0122 
       4  0.937   0.323  0.0532  -0.0325 
       5 -0.0671 -0.614  0.140    0.00120
       6 -0.749   0.117  0.191    0.0369 
       7  0.0209 -0.790 -0.0441   0.0959 
       8  0.687   0.220  0.00900 -0.0259 
       9  0.746   0.146  0.0135   0.0184 
      10  0.586  -0.211  0.0302  -0.0626 
      # i 990 more rows

# relocate_clusters() works

    Code
      relocate_clusters(data = df, vert_mat = vert_mat)
    Output
      # A tibble: 12 x 5
              x1      x2      x3     x4 cluster
           <dbl>   <dbl>   <dbl>  <dbl>   <int>
       1 -1.18    1.62    5.14   -1.38        3
       2 -1.30    5.05   -0.0169  1.58        2
       3  3.54   -0.523  -0.131   0.433       1
       4  6.15    0.241   0.106  -0.330       1
       5  0.607   4.33   -0.700  -0.954       2
       6  0.620   5.63   -0.717   0.944       2
       7  2.27   -0.712   5.45    0.692       3
       8 -0.352   0.133   5.05   -0.293       3
       9 -0.736  -1.04    4.36    0.983       3
      10  0.0754  4.99    1.43   -1.57        2
      11  6.12    0.367  -0.106  -0.990       1
      12  4.19   -0.0853  0.131   0.887       1

# gen_nproduct() works

    Code
      gen_nproduct(7, 2)
    Output
      [1] 2 3

# gen_nsum() works

    Code
      gen_nsum(30, 3)
    Output
      [1] 10 10 10

# gen_wavydims1() works

    Code
      gen_wavydims1(n = 500, p = 4, theta = seq(pi / 6, 12 * pi / 6, length.out = 500))
    Message
      v Wavy shaped noise dimensions generation completed successfully!!!
    Output
      # A tibble: 500 x 4
              x1    x2      x3    x4
           <dbl> <dbl>   <dbl> <dbl>
       1  0.598   2.11  0.330   1.17
       2  0.419   1.43  0.920   1.30
       3  0.0740  1.80  0.409   2.02
       4  0.683   2.01  0.551   2.39
       5  0.531   2.32  1.29    2.12
       6  1.30    1.96  0.556   2.09
       7  1.23    2.15  0.937   2.08
       8 -0.330   1.72  1.47    1.79
       9  1.29    1.78  0.695   2.56
      10 -0.125   2.62 -0.0498  1.75
      # i 490 more rows

# gen_wavydims2() works

    Code
      gen_wavydims2(n = 500, p = 4, x1_vec = x1)
    Message
      v Wavy shaped noise dimensions generation completed successfully!!!
    Output
      # A tibble: 500 x 4
                x1        x2       x3       x4
             <dbl>     <dbl>    <dbl>    <dbl>
       1  0.000910  0.0185    0.0143  -0.0331 
       2 -0.00919  -0.00517   0.0170   0.0629 
       3  0.0186    0.00205  -0.00405 -0.00339
       4  0.0222    0.0312    0.00931 -0.00348
       5  0.00516   0.0139    0.00406 -0.00304
       6  0.0123    0.0238    0.00255  0.0591 
       7  0.00881   0.0309    0.00899  0.0691 
       8  0.00412   0.00188   0.0107  -0.0226 
       9  0.00292  -0.00113   0.0154   0.0264 
      10 -0.0106   -0.000241 -0.00240  0.0336 
      # i 490 more rows

# gen_wavydims3() works

    Code
      gen_wavydims3(n = 500, p = 4, data = df)
    Message
      v Wavy shaped noise dimensions generation completed successfully!!!
    Output
      # A tibble: 500 x 4
             x1    x2      x3    x4
          <dbl> <dbl>   <dbl> <dbl>
       1 -0.627 0.795 -1.78       0
       2  0.602 1.48  -0.217      0
       3 -0.780 0.346  1.64       0
       4 -0.968 1.19   0.791      0
       5  0.607 1.61   1.79       0
       6  0.237 0.703 -1.97       0
       7 -0.589 1.38  -1.80       0
       8 -0.325 0.476  0.0497     0
       9  0.978 0.735 -0.809      0
      10  0.532 1.85  -0.156      0
      # i 490 more rows

# gen_rotation() works

    Code
      gen_rotation(p = 4, planes_angles = rotations_4d)
    Output
                [,1]       [,2]         [,3]          [,4]
      [1,] 0.5000000 -0.8660254 0.000000e+00  0.000000e+00
      [2,] 0.8660254  0.5000000 0.000000e+00  0.000000e+00
      [3,] 0.0000000  0.0000000 6.123234e-17 -1.000000e+00
      [4,] 0.0000000  0.0000000 1.000000e+00  6.123234e-17

# normalize_data() works

    Code
      normalize_data(data = gau_data)
    Output
                     x1           x2            x3            x4
      1    0.3693006368 -0.179963438 -3.620957e-01  0.3600654960
      2    0.1057937632 -0.043198498 -4.293747e-01  0.1094879924
      3   -0.1301659541  0.834924780  1.014744e-01 -0.0061040149
      4    0.0711319345 -0.020276851 -1.428199e-01  0.1065253357
      5   -0.0873354387  0.095546900  1.143296e-01  0.2746812833
      6    0.3748332591 -0.279412605 -4.238094e-02 -0.3720674962
      7    0.0974284791  0.104320996  3.093415e-02  0.0380285626
      8   -0.2461998150  0.351592959 -5.484355e-02 -0.2509539698
      9    0.1016229399  0.187176820  7.591812e-02 -0.1189938748
      10  -0.0607525074  0.280334001  1.532177e-01 -0.2456853841
      11  -0.1767904104 -0.350287977  5.342028e-01  0.3551694500
      12  -0.3550684080  0.226238625 -4.980786e-02  0.3078627895
      13   0.0924627149  0.197817268  7.058763e-01  0.0676854182
      14   0.3048320270 -0.169774056  3.221086e-01 -0.0873600229
      15   0.0492465973 -0.403753550 -2.804754e-01 -0.0307742351
      16   0.0647872593  0.151362054  5.246121e-02 -0.1005772290
      17  -0.3527463580  0.140600301  4.400104e-01  0.1596131240
      18   0.2264548481  0.184993189 -1.392550e-01 -0.0975747994
      19   0.2324063065  0.081462693  3.279301e-01 -0.3557176673
      20   0.0767016185  0.022514687  3.692406e-01  0.1302300963
      21   0.2255312952 -0.395040987  2.312342e-02  0.0919671863
      22   0.0398717390 -0.229554979 -1.606570e-01 -0.0988942316
      23   0.5467388291  0.464596780 -2.370090e-01 -0.2501065294
      24   0.2814297285 -0.118343407 -2.489047e-01 -0.1453261478
      25  -0.0786021104 -0.326523952 -1.493555e-01  0.3564525265
      26  -0.5195097973  0.344273338  5.498254e-02 -0.0682335110
      27   0.7849012985 -0.310050679  2.506426e-01  0.2254039566
      28  -0.0166514022  0.134505827 -2.881376e-01  0.2453058186
      29  -0.3415982671  0.039098346 -2.322333e-01  0.0455593609
      30   0.1898096476  0.295351770  2.836743e-01  0.4723934931
      31  -0.0158329831 -0.317056883 -1.228761e-01  0.5063578148
      32   0.0195052881 -0.010257692  4.909064e-02  0.3214198548
      33  -0.3268335588 -0.101812761 -4.811331e-01  0.1651827884
      34  -0.0527044253  0.297278470 -1.569525e-01  0.6337323506
      35   0.4599037810 -0.028334494  2.670015e-01  0.3036369762
      36  -0.3108544232 -0.297875880 -1.688093e-01  0.0244480523
      37  -0.2558617807 -0.807391318 -4.144028e-02 -0.2102324693
      38  -0.1315486300  0.533286243 -3.544538e-01  0.3982676620
      39  -0.9122417994  0.010987655 -2.205360e-01 -0.2946237679
      40  -0.0366062462 -0.061302954 -1.852414e-01  0.1694944570
      41   0.1139483557  0.153612424  2.766472e-01  0.4539867822
      42  -0.1163351964  0.130561804  2.634213e-02  0.0449683540
      43  -0.4209995339  0.302655724 -7.526846e-01 -0.1138244786
      44   0.3890108458 -0.103020928 -3.558588e-02  0.0050635516
      45  -0.2826764713 -0.012404155 -1.107704e-01 -0.0049448795
      46   0.2430049561  0.284002241  1.691475e-02 -0.4128190593
      47  -0.5240586662 -0.309221964 -2.242118e-01 -0.4287870820
      48  -0.2273541028 -0.142809953 -6.897029e-02  0.3110241951
      49  -0.0379616507  0.043001661  1.371656e-01 -0.3925920948
      50   0.0780893837 -0.241122287 -2.863742e-02  0.2755573510
      51   0.1048819495 -0.198822394 -7.561111e-01  0.1701353748
      52  -0.3009894207 -0.077535504 -2.449463e-01 -0.2182121260
      53  -0.0325998150  0.097552428  4.954835e-02  0.0968713220
      54  -0.0092043358  0.236247475 -1.841998e-01  0.5291052764
      55   0.2752794644  0.133680928 -3.695012e-01  0.0313653027
      56   0.0465821760 -0.427285450  2.816384e-01 -0.0525370578
      57  -0.4087923768 -0.449658440 -8.869659e-02  0.0213818841
      58  -0.0663021950 -0.050396333  2.413258e-02 -0.1582469137
      59  -0.2623470503  0.063838089 -4.984759e-02  0.1948949975
      60   0.1974110054 -0.430917127  3.131939e-02  0.5102615559
      61  -0.1980127557  0.455357599 -8.664931e-02  0.2752170262
      62  -0.0762354387  0.499231760  1.493527e-01  0.1603901298
      63   0.0363466457 -0.429066024 -6.953249e-02 -0.2648885666
      64   0.2428755087  0.134157923 -9.138422e-02  0.0681463038
      65   0.3902626823 -0.137450186 -5.575418e-02 -0.2237724104
      66  -0.2153014386 -0.036506235 -1.491948e-01  0.0200956042
      67   0.1185473185 -0.149601136 -1.242851e-01  0.2490856975
      68   0.1978516281 -0.253968549 -1.027500e-01 -0.5290245857
      69   0.3106559817  0.055412362 -2.714536e-01  0.0103369516
      70  -0.2928804639  0.203557160 -3.021592e-01 -0.6284822669
      71   0.0344865823 -0.061787812  1.485575e-01 -0.2387142440
      72   0.4115253153 -0.047047584 -2.342951e-01  0.0817817717
      73   0.2899964332  0.078831140 -1.209357e-02  0.0671713459
      74   0.3171662213 -0.099252585 -9.994084e-02 -0.0957527001
      75  -0.0849068772 -0.026795605  2.562617e-02 -0.1966572028
      76  -0.0868288182 -0.314685689 -4.729964e-01  0.3194171409
      77   0.2910791669 -0.543528461  4.767357e-01 -0.1094103690
      78  -0.0146918704  0.074857325 -1.431060e-01 -0.0790044616
      79  -0.1170385209  0.211245167 -2.748339e-01  0.1483207554
      80   0.1381722767 -0.352056345  8.447390e-02 -0.3864492326
      81  -0.3065324341 -0.129107322 -1.145691e-01  0.2269264155
      82   0.0570364621 -0.198197773 -4.667407e-01  0.3369398776
      83   0.1660916655  0.089966578 -1.771334e-01  0.0086729834
      84   0.0422335110  0.494322825  3.357479e-01 -0.4340042938
      85   0.1339557564  0.146181437 -3.987728e-01 -0.1564619209
      86   0.1406058250 -0.392223246  4.462491e-01 -0.1613005723
      87  -0.3744367445 -0.433647037 -3.977300e-01 -0.4128746220
      88   0.1900088395 -0.017496408 -2.286547e-01 -0.2407606341
      89  -0.3222989415  0.257076487  2.048654e-01  0.3534114242
      90  -0.2629553666  0.418554695 -1.647824e-01 -0.4601046908
      91   0.0569703585  0.176812907 -5.007294e-01  0.0300074626
      92  -0.4255321967  0.222812063 -3.800142e-01  0.3648722210
      93  -0.1400764475 -0.048760714 -2.888300e-01 -0.1062032656
      94   0.2475690696  0.092414284 -3.121600e-01 -0.3259465627
      95  -0.0757145712 -0.031038939 -4.687330e-02  0.7333724947
      96  -0.0697768047  0.359547206 -4.011652e-02  0.0570909075
      97   0.0335990763 -0.307326489 -1.707903e-01  0.3020860691
      98   0.0408553026 -0.072103532  8.212123e-02  0.0585252503
      99  -0.3923498782 -0.039677650 -1.055452e-01 -0.0158149387
      100  0.1758272252  0.134888928  2.876379e-01  0.2778308294
      101 -0.0999931627 -0.210603378 -1.886710e-01  0.4979369748
      102  0.1802114569 -0.039261453  4.274581e-01  0.1695981463
      103  0.4526953163 -0.180416435 -6.781021e-01  0.0456824225
      104 -0.2843350550  0.172729975 -1.207482e-03 -0.1778790946
      105 -0.5899047255  0.142815474  1.852201e-01  0.0154132163
      106 -0.1731064753  0.316089763 -3.760808e-01  0.2414355416
      107  0.2850493171  0.023953398  7.798890e-02  0.1613078572
      108 -0.4412994249  0.728076171 -1.118465e-01 -0.1182700350
      109 -0.5808587413  0.050788322  1.806935e-01 -0.4014483472
      110  0.1461441421 -0.173672141  2.566645e-01  0.2497122155
      111  0.1093395271 -0.159263088 -3.394792e-01 -0.1901198023
      112 -0.1465654400  0.368728913 -4.460743e-01  0.3873609474
      113  0.0611108832 -0.108101873  2.997534e-01 -0.2080333161
      114 -0.3028314533 -0.132529803  2.693790e-02 -0.2620179269
      115  0.2976830344 -0.456122546 -3.040581e-01 -0.0255831454
      116 -0.2408484986 -0.312072729 -6.481284e-02 -0.2179413030
      117 -0.1952294661  0.036174124 -8.260877e-02  0.1457779242
      118 -0.0374100903 -0.142029635 -1.878964e-01  0.1794134339
      119 -0.1382139043  0.481723084 -4.088015e-01 -0.0729075144
      120 -0.1295839363 -0.232853099 -1.642595e-01  0.2822907506
      121 -0.4767084221 -0.214697248  1.533807e-01 -0.3943073216
      122  0.5319722456  0.260724797  5.060870e-01  0.1564116062
      123  0.1115198657  0.203381870  4.220151e-01  0.0421505306
      124 -0.0892932651 -0.378203948  4.249181e-01  0.0325061481
      125  0.0418835734 -0.240500733 -2.406838e-01 -0.0813216823
      126  0.2776557947 -0.321232138  2.207238e-01  0.1086645377
      127 -0.2058872467  0.260408474  7.227799e-02 -0.0661440045
      128  0.1022907928 -0.176641292  1.655540e-01 -0.0345495971
      129 -0.0115609821 -0.491911985  3.697170e-01 -0.0097048677
      130 -0.0177882925  0.795575728 -1.296543e-01  0.3245314061
      131 -0.1530591217 -0.255753387  3.479418e-01 -0.3480189883
      132  0.1045096542 -0.153865166  3.474034e-01  0.3029829786
      133 -0.5753120938 -0.273408686  1.945217e-01 -0.2031341051
      134  0.1524298866  0.037071728 -1.956007e-01  0.0269329943
      135  0.1173088719 -0.039351300 -3.485378e-01  0.1753765160
      136 -0.2044062905 -0.421192942 -5.538974e-01 -0.3227348999
      137  0.3263375252  0.011921927 -7.525749e-02  0.0650248730
      138 -0.2004270494  0.136082857  2.684102e-01  0.0911429643
      139 -0.0190128001  0.193757879 -1.579784e-01 -0.2880825444
      140 -0.0531020669  0.158138185  1.257465e-01  0.3919725430
      141 -0.2476791711  0.270826875 -3.341787e-01 -0.0590120715
      142  0.0002622793 -0.138487302  1.865178e-01 -0.0148929712
      143 -0.6995289039 -0.074803619 -3.430501e-01  0.2928667184
      144 -0.2050279975 -0.053917500  1.566459e-01  0.0964229340
      145 -0.1724024817  0.593801855  3.156763e-01  0.0352889390
      146  0.2768819504 -0.321258435 -1.025659e-02 -0.3625356662
      147  0.1076154207  0.536178923  4.830665e-02 -0.2741001603
      148 -0.4016690686 -0.120121119  1.225375e-01 -0.2248658781
      149 -0.4218479356  0.049053413 -2.341708e-01  0.3107929178
      150 -0.5880397999  0.086504180  8.990896e-02 -0.1111230901
      151 -0.0484891387  0.173532894  4.844755e-02  0.2053580596
      152  0.0293839442  0.255812923  2.937116e-01  0.0760954104
      153  0.4728184685  0.012281203  4.790987e-01  0.1139824053
      154 -0.6300540428  0.227339964  1.269042e-01  0.2547083318
      155  0.2674413997  0.016557216  4.465670e-01  0.3567753685
      156  0.1803627638 -0.243992941 -9.650526e-02 -0.0420383452
      157  0.2939513245 -0.091597979 -1.580241e-01  0.1844522710
      158  0.0305381078 -0.003684399 -2.987732e-01  0.3563560726
      159  0.3176876989  0.017705942  3.178778e-01  0.2117778987
      160  0.2417988351 -0.201978988 -1.667698e-01 -0.0731894208
      161  0.5807365163 -0.214461463  3.122661e-03 -0.2510521205
      162  0.0085059284  0.307915998 -4.386611e-02 -0.0459714764
      163 -0.3042600742 -0.313966264 -6.023356e-01 -0.0548980719
      164 -0.4281958259 -0.153229661  1.960088e-01  0.2607663088
      165  0.2168729635  0.104890410  5.698988e-02  0.0665634367
      166  0.3671638902 -0.172071917  1.837052e-01  0.1077571723
      167 -0.2198923081  0.696429890  5.063825e-02 -0.2566734119
      168  0.3609472093 -0.107241339  2.334582e-01 -0.1357101047
      169  0.0094098681  0.018996341 -4.504881e-02  0.2908323110
      170  0.4174502045  0.295978461 -2.760697e-01 -0.1893839081
      171  0.1957997021  0.638908956  1.872005e-01 -0.4540662505
      172 -0.3291710150 -0.059364722  1.306080e-01 -0.4298820037
      173 -0.3201043639 -0.327710898  5.263342e-01 -0.0620231353
      174  0.2203017681 -0.259435924 -2.489475e-02 -0.3037798782
      175  0.6474999029  0.205385058 -5.440950e-02 -0.4136572573
      176  0.1952311846  0.444902871  2.230748e-01  0.0578485371
      177  0.0070604447 -0.084081213 -7.339901e-01 -0.0764766533
      178  0.3018053829 -0.534522346 -6.053889e-01  0.0889593426
      179  0.1323707654  0.198901652  1.490083e-01  0.0694725171
      180  0.3965722282  0.066967391  4.734547e-01  0.3103685249
      181 -0.1401488545 -0.211952866  3.954887e-01  0.2982106835
      182 -0.3496913308  0.114624127  3.651737e-02  0.1502034045
      183  0.1912577495 -0.125005832 -2.622365e-01  0.2824236072
      184  0.3385359461  0.275732294 -7.665722e-02 -0.4206379301
      185  0.0500534130 -0.122652451 -3.745592e-01  0.1775681920
      186  0.1644601148 -0.310239620 -1.297203e-01 -0.4136215230
      187  0.0315718874  0.252285322 -4.747155e-01  0.1382399473
      188  0.1031364761 -0.062652979 -4.793701e-01  0.0632028820
      189 -0.1528439822  0.387462774 -4.762042e-01 -0.1262608696
      190 -0.4142607180 -0.141894914 -1.396826e-01  0.3353066501
      191  0.0306471365 -0.347187815 -3.098633e-02  0.2130421290
      192  0.3575624725 -0.208621899 -4.960874e-01 -0.2205512399
      193 -0.0059326867 -0.096823723 -1.999414e-01 -0.3618567063
      194  0.1047378914 -0.230701184  4.647200e-01  0.3271154825
      195  0.3886921635  0.232144815 -3.669244e-01 -0.0686189230
      196 -0.3842090286  0.085941581  3.665920e-01 -0.4728150059
      197 -0.1156771564  0.274636635  1.000000e+00 -0.2629351580
      198  0.3911396714 -0.226931782  1.909692e-01  0.2723251154
      199 -0.2411541073 -0.328184808 -1.015357e-05  0.1300191723
      200  0.0291507257  0.518333574  1.791766e-01 -0.1764927301
      201 -0.0994059632 -0.086923706  2.885617e-02 -0.0072344180
      202 -0.1651989692 -0.269915836  3.389723e-02 -0.3441340935
      203 -0.1970094110 -0.287387613 -9.981280e-02  0.3967960546
      204  0.4116730518  0.086126898  2.715384e-01  0.4089528893
      205 -0.1361637719  0.064435668 -4.608141e-03 -0.1460120695
      206 -0.1419066109  0.165165887 -2.343400e-01 -0.0602715047
      207  0.0989117963  0.329799415  2.272890e-01 -0.0319407791
      208  0.2336784369  0.304373115  1.339548e-01  0.7018232491
      209 -0.4828765343  0.163612472  1.261441e-01  0.0184769626
      210  0.5099889705  0.267995358  1.670078e-01  0.0998935709
      211  0.0495796283  0.098880295 -2.884816e-01 -0.0982972193
      212  0.2443830051 -0.012130825 -3.509948e-01 -0.3335510241
      213  0.2434788423 -0.025938924  3.424272e-01 -0.0818869366
      214 -0.0150817964  0.322107951  1.848159e-01 -0.2594344770
      215 -0.3677346803  0.010900797 -3.832160e-01  0.5534625803
      216  0.5475274154  0.534836531  2.971229e-02  0.4207661328
      217 -0.0966225295  0.461298226 -1.046621e-01  0.3109547515
      218  0.0444264676  0.317424052  2.080640e-01  0.2711098216
      219 -0.2517995238 -0.509116963 -1.202336e-01 -0.2768683133
      220 -0.1729398461  0.363976322 -1.289116e-01 -0.0294896624
      221  0.2628380077 -0.165688070  1.843366e-01  0.1893759886
      222  0.9161294185  0.195124077  5.468910e-03  0.0906063883
      223  0.3979363036  0.212221335 -1.796614e-01 -0.2480078149
      224 -0.1170063564 -0.738075852  4.809759e-02  0.0720135004
      225 -0.1141401157  0.102142695  2.590062e-01 -0.1835899912
      226  0.1859193861 -0.064039958 -9.966693e-02  0.1994307543
      227 -0.2946662187 -0.139879756 -4.896306e-01 -0.1939963271
      228 -0.2689520194 -0.086452080  4.549768e-02  0.1575692052
      229  0.3660264067 -0.108707489  1.691410e-01  0.0007861439
      230 -0.6404110846 -0.110457016  1.532136e-01  0.4133641297
      231  0.0068649672  0.066315394  5.179371e-01 -0.0618302970
      232 -0.0478616946  0.026851763 -1.518162e-02  0.1694947848
      233  0.0614733968  0.451946555 -3.093316e-01 -0.0024509919
      234 -0.0657765112 -0.193493725 -2.036833e-02 -0.0622748323
      235 -0.3421522388 -0.367513415 -1.193782e-01  0.2139627187
      236 -0.2285832561 -0.128551318  7.472238e-03  0.0426813674
      237  0.0450476199 -0.079276530 -1.927783e-01 -0.0588040370
      238  0.1382523252  0.349624445  3.597214e-01 -0.2493206442
      239  0.0270922459 -0.056629392 -1.668769e-01  0.1552375571
      240 -0.0446927499  0.028880377  1.772144e-01 -0.1180927947
      241 -0.2859841261  0.019730542  6.769492e-02 -0.0669653030
      242 -0.4777031448 -0.134887360  5.528737e-01 -0.3660797886
      243 -0.3394388703  0.289029027 -3.349876e-01 -0.3740944573
      244  0.7505610451  0.257506595 -3.192126e-01 -0.0348195908
      245 -0.1942266938  0.212788548  2.839766e-01 -0.2175798881
      246 -0.2162658061 -0.447072025  6.258055e-02  0.0554275283
      247 -0.1655449164 -0.524544032  1.286898e-01 -0.2867429192
      248  0.1066099349  0.366799787 -2.817115e-01 -0.1667724235
      249 -0.1451488986 -0.060096036  1.442339e-01  0.0564287923
      250 -0.3992132417 -0.083573460 -3.693267e-02  0.1044653171
      251 -0.3204591986  0.358836193 -3.642290e-01  0.0599853840
      252  0.3533995927 -0.311223124 -1.751463e-01 -0.0267200161
      253 -0.3649464071  0.312734117 -2.748427e-01  0.4537251049
      254 -0.3097441766  0.243529371  1.574431e-01 -0.0854351043
      255  0.1639721860 -0.668316664  2.365444e-01 -0.3339791192
      256 -0.0922470305  0.635094329 -2.971014e-01  0.3802225636
      257 -0.1660233463 -0.239483097 -2.621717e-01 -0.4125815958
      258 -0.1765261490 -0.301475006 -6.648998e-02  0.3244480351
      259  0.1678901612 -0.154032268  9.036653e-03 -0.0675920374
      260  0.2677784917  0.113770532  2.347683e-01  0.1003420708
      261 -0.1352441532  0.257294800  5.345793e-02 -0.1641393293
      262  0.0479813479 -0.001505572  3.342583e-01 -0.1139747390
      263 -0.2849056542  0.068744411  8.287281e-02 -0.3914885222
      264  0.3190592402 -0.140873391  3.654301e-01 -0.2341168882
      265  0.0171755832 -0.512787097  4.471813e-01  0.2332783154
      266  0.0945706979 -0.260730722 -2.942830e-01  0.3161827574
      267  0.3846818369 -0.554364929  2.396872e-01 -0.1558422876
      268  0.2284183527 -0.103323775 -1.826059e-01 -0.1289161539
      269  0.3148672256 -0.062177515  1.123998e-02  0.3298017125
      270 -0.0281525578 -0.149431831  5.566658e-01  0.1941153945
      271  0.2262846503 -0.165513479  5.231897e-01  0.4891680019
      272  0.2207055756 -0.312575080  2.612536e-02 -0.1671610499
      273 -0.4573198968  0.317025952 -1.627894e-01  0.2552991658
      274  0.0618595009 -0.008927881  5.131405e-01  0.5786711398
      275 -0.1124405397 -0.151968118 -3.601227e-01 -0.1181707102
      276  0.1561524445  0.078953295  2.139760e-01  0.2373909299
      277  0.4536613046 -0.310112919 -2.560488e-01 -0.0687362275
      278  0.1466312511 -0.015496230  5.469523e-01  0.2270650382
      279  0.5514956027 -0.080166789 -3.965306e-01 -0.1450021860
      280  0.2568774555 -0.294112868 -3.136242e-01  0.1044155566
      281 -0.3708901294  0.003537579 -1.168445e-01  0.3412682121
      282  0.0886381378 -0.223668297  2.075933e-01 -0.2294815409
      283 -0.0324945672 -0.501443698  1.129809e-01  0.2451740143
      284 -0.1527096389  0.006826565  3.295651e-01 -0.1307454889
      285  0.1508852994  0.290593628  3.755293e-01 -0.0966616881
      286 -0.2214848676 -0.400799877  4.854291e-01  0.1801072459
      287  0.1428122835  0.231464978  8.833303e-02  0.2710319832
      288 -0.0337977309 -0.171710515 -3.684257e-01  0.6718104401
      289  0.1039648159  0.258154678 -1.336735e-01 -0.2903387888
      290  0.0095751856 -0.403304306 -7.997894e-03  0.3785791512
      291  0.6928773189 -0.410763263  3.408513e-01  0.0763728431
      292 -0.2232764089  0.433862626 -3.773662e-01  0.0788132538
      293 -0.4482113222 -0.045586930 -3.852249e-02  0.2464411916
      294 -0.1592302908  0.094596134 -1.203623e-01 -0.0814072956
      295  0.6269428328  0.297370695  2.378007e-01 -0.7928928352
      296  0.1235122235 -0.192562425  1.929052e-01 -0.1913204035
      297  0.1512759834  0.290720351 -1.280586e-01  0.5765937477
      298  0.5187010487 -0.220695221 -2.814983e-01  0.3373256274
      299  0.3479904171 -0.007724201 -2.733409e-01  0.0062836582
      300  0.2881563402 -0.064609783  4.227217e-01 -0.2030040505
      301  0.1183915120  0.096063653  4.809783e-01  0.2851321275
      302 -0.0738803842  0.371162703  2.329097e-01 -0.1788352754
      303 -0.0901570236  0.204728692  1.583075e-01 -0.1960261939
      304 -0.0351333007  0.204985658 -5.745672e-01 -0.0567375705
      305 -0.1797808431  0.160303314 -1.629703e-01 -0.5684328901
      306  0.0811826969 -0.162574484  1.555344e-01  0.5053353104
      307  0.3972463802  0.393803721  2.029171e-01  0.5647807477
      308 -0.0211393383 -0.734753353  1.191434e-02  0.0962468864
      309 -0.1754396472 -0.088087143  2.079981e-02 -0.1252340567
      310 -0.4080982585  0.264673396  1.652562e-02 -0.2689427748
      311  0.0608859020 -0.300467286 -1.405437e-01 -0.0127765725
      312 -0.2922713431  0.474462871  2.483029e-01 -0.0397658922
      313 -0.0236116911  0.193986657 -1.980119e-01 -0.0939234124
      314 -0.3311260916 -0.251601532 -3.713126e-01 -0.4115002311
      315 -0.3721850149  0.257308627 -3.954104e-01  0.0267693073
      316  0.0583653421  0.582713206 -5.474014e-01  0.2956217457
      317  0.5217694961  0.011905305 -1.041013e-01  0.0439742254
      318  0.0006012636  0.456606177  2.380067e-02  0.4373619561
      319 -0.1606104534  0.254882631 -1.916626e-01  0.1100803785
      320 -0.0639539701 -0.145855018  2.559838e-02  0.1642496363
      321 -0.2176579920  0.050723982 -1.629870e-01  0.3908902107
      322  0.5719586608 -0.180496021 -2.135815e-01 -0.2130806539
      323  0.0582800263 -0.143402570 -5.029913e-01 -0.0309072993
      324 -0.0911368301 -0.126255803 -2.195222e-01 -0.1217579351
      325  0.3777315019 -0.536866865  2.751932e-01  0.0373126824
      326 -0.0424248381 -0.497125762 -8.419423e-02 -0.1799359596
      327  0.2316190415 -0.086821159 -1.321267e-01  0.4007137482
      328  0.5757371807 -0.148976206 -2.424158e-01  0.4667404134
      329 -0.1064939442  0.011066613  2.176981e-01  0.0917293895
      330 -0.0188659459 -0.085325607 -6.707996e-02  0.3592725538
      331  0.1003105665  0.014975262  3.160743e-01  0.2796967005
      332 -0.4826498010  0.259126705  1.992599e-01 -0.0676612731
      333 -0.5685921354  0.004131710  8.993264e-02  0.0208805124
      334 -0.1233866110  0.109135710  2.756016e-02 -0.0998866981
      335  0.0096719659 -0.382338973 -1.709548e-02  0.0016243841
      336  0.5130332504 -0.089120172 -1.287097e-02 -0.0528279107
      337 -0.5522641136 -0.040756071 -4.111337e-01 -0.3370709329
      338 -0.0718833128  0.350457467  1.878696e-01 -0.3459145294
      339  0.1385501873 -0.717186241 -1.407570e-01 -0.1945317110
      340 -0.1959648293 -0.328214375 -5.154936e-01  0.2178530437
      341 -0.4583574220 -0.217687207 -1.121747e-01  0.2220440952
      342  0.1238965387  0.410342631 -1.196944e-01 -0.1188011830
      343 -0.1895442128 -0.048146348  1.556034e-01  0.3153433270
      344  0.0189254843  0.148575726 -4.342314e-01  0.4023003247
      345 -0.0601148715 -0.139950782 -5.050546e-03  0.4065731779
      346 -0.2434308972  0.004051377 -1.493340e-01  0.1237034501
      347  0.0883271441 -0.081822114  1.128038e-01 -0.1467782526
      348 -0.2061570245 -0.229377415 -3.719668e-02  0.7518991822
      349 -0.1284286805  0.268432462 -1.946838e-01  0.1141091288
      350 -0.0302834714 -0.258267929 -4.281806e-02 -0.2592559821
      351  0.4310313962  0.001583943  4.443435e-01  0.2427559820
      352  0.1651801645  0.445190162  2.594133e-01 -0.0469701553
      353 -0.3824798147 -0.193866814 -3.386621e-01 -0.1966282116
      354  0.0955969930  0.335531858  5.082329e-01  0.2096409955
      355 -0.1002313572  0.158121432  3.632976e-01  0.4884278785
      356 -0.1201629945  0.352465694  3.018839e-01  0.2399802565
      357 -0.2815308366 -0.100121721  2.874528e-03  0.5879104578
      358  0.1345325499  0.006462718  8.527081e-02  0.2457843787
      359 -0.0131017098 -0.119192814 -1.344844e-01 -0.2066095250
      360 -0.2699881205  0.056041369 -3.015385e-01  0.1513979045
      361  0.2112512997 -0.323383535 -9.403118e-02  0.2177698866
      362 -0.2961822326  0.182811095  9.588788e-02 -0.2730440900
      363 -0.1290411688  0.182832962  3.665106e-01 -0.1418118090
      364  0.4150067913  0.389629068 -2.870505e-01  0.1967513742
      365 -0.0884209188 -0.082681189  4.548965e-02 -0.0250947343
      366 -0.2660712171 -0.359022164 -2.454713e-01 -0.4005495822
      367 -0.0189826679  0.293035352  2.057055e-01  0.1331113149
      368 -0.2124491794  0.006242171 -2.449086e-01 -0.5091663444
      369  0.1693257160 -0.253867719  1.103232e-01  0.1771654248
      370  0.3530736848 -0.451202257 -3.910847e-03 -0.0116615265
      371 -0.2567536430  0.184075612 -4.113692e-01  0.3446723533
      372  0.4074854796 -0.144925128  2.992209e-01 -0.1173092495
      373 -0.2209920205 -0.170329326  1.378639e-01 -0.1465573026
      374 -0.2705725283 -0.198952168 -1.773708e-01  0.0524795515
      375  0.1629412807  0.408084567 -3.376447e-01  0.0949232064
      376 -0.0761569947  0.288659826 -3.342570e-01  0.5887789719
      377  0.2877731926  0.137349213  4.145374e-01  0.1729054372
      378  0.1600305727  0.049675967 -1.535960e-01 -0.1313059448
      379 -0.1850528783  0.476038696 -3.667072e-01 -0.1941246757
      380 -0.4753043952 -0.110832625  1.032584e-02  0.1054539625
      381 -0.0969546447  0.404273387 -5.554333e-01  0.4055868561
      382  0.1721261897 -0.057415894  1.132335e-01 -0.2355060158
      383 -0.5401186228 -0.381024783  1.609573e-01  0.2620500190
      384 -0.2825341140  0.149465062  1.994612e-01 -0.1087784252
      385  0.1557334320 -0.102722354 -4.856033e-01 -0.0817060487
      386 -0.0169848419 -0.209487809 -2.453344e-01  0.1517797431
      387  0.5639341098  0.240753591  3.468178e-01  0.1606646983
      388  0.3115613526  0.117950130  3.564219e-01  0.0824735281
      389  0.1788855556 -0.030721677  1.889214e-01  0.0776250554
      390 -0.6732683323 -0.126580912  4.074472e-01  0.1805035177
      391 -0.4859052911 -0.229985927 -3.742549e-01 -0.2889975941
      392  0.3034586738  0.292469642 -5.439388e-03 -0.2085875279
      393 -0.2214226561 -0.493721297  8.954898e-02  0.1228146518
      394  0.2644760194  0.069533630 -8.799342e-02 -0.2510332082
      395  0.1850800733 -0.279988896  4.134895e-01  0.0285390392
      396  0.2190143465 -0.142126581  6.318342e-01 -0.0774204941
      397 -0.1236077005 -0.084285143 -1.199579e-01 -0.0296894578
      398  0.2348321021  0.023000553  1.159859e-01  0.0318873193
      399  0.0133006091  0.133717997 -1.541392e-01  0.1865971133
      400  0.1004216416 -0.234344200  5.182316e-01 -0.2261054378
      401  0.3026690477 -0.005478088 -2.525674e-03  0.0536112798
      402  0.5349058693 -0.183491797 -1.508686e-01  0.4402442246
      403 -0.4482967617  0.106913986  5.960744e-02 -0.4405706388
      404  0.3000229862  0.140269299 -4.939180e-01  0.1505755068
      405  0.0332832901  0.252452318 -4.793419e-02 -0.1365453003
      406 -0.2044910550 -0.372877065  9.174742e-02  0.3130841346
      407  0.0812561891 -0.166844276  1.004726e-01 -0.1456531852
      408  0.0308058730  0.450318589  1.035044e-01 -0.4882537227
      409 -0.1507260926  0.248854773  4.809404e-02  0.4063829149
      410  0.1650225260 -0.047579335  1.877350e-01  0.5193605538
      411 -0.1716570663 -0.339553140  7.094589e-01 -0.2018430071
      412  0.2107081596 -0.136293947 -1.687856e-01  0.2975009838
      413 -0.2567820907  0.110034694 -1.675597e-01 -0.1243546212
      414  0.2475707538  0.037991899 -8.066569e-02  0.0463531533
      415 -0.0499114726 -0.676421749 -5.669210e-02 -0.7105759888
      416  0.3361630889 -0.446245076  5.921012e-01  0.5439440501
      417 -0.0908894582 -0.385823646  7.833212e-02  0.1061073712
      418 -0.0419086061  0.183239960 -2.483000e-01  0.0641450188
      419  0.0376035452  0.421112602 -9.365337e-02  0.0920127989
      420 -0.1028486806 -0.183590073 -3.060987e-02 -0.4006115160
      421  0.0045640247  0.056476455  2.999212e-02 -0.0044158977
      422 -0.4074024039  0.094723595 -3.310793e-01 -0.0149332595
      423  0.1583587489  0.031234332  1.315960e-01 -0.1946649150
      424 -0.0689974877  0.077876771  3.382044e-01  0.3625955544
      425 -0.3828808145 -0.319551682  4.172256e-01  0.2235676510
      426 -0.5963371406 -0.177896255 -2.347942e-01  0.8294185099
      427 -0.1715855999 -0.195016217 -4.672190e-01 -0.0537893043
      428 -0.2502332783 -0.384134905 -4.876246e-01 -0.2852008911
      429 -0.1335074907 -0.244225611 -4.090568e-01  0.5143273130
      430  0.1737972778 -0.209583718  2.100014e-01  0.5578516414
      431  0.1878552774  0.442669601  2.269509e-01 -0.5371802938
      432  0.1172361118 -0.090746067  3.541106e-01  0.1912425075
      433 -0.1869307735 -0.476736726  3.555026e-01  0.1571952341
      434  0.2099082618 -0.238836031 -3.886980e-01 -0.1211250255
      435  0.0761909916  0.325219124 -6.563840e-02 -0.3041546365
      436 -0.3001624787  0.653011368 -4.629031e-02  0.2800699729
      437  0.1154938365 -0.217233173 -4.533547e-02 -0.5024737753
      438  0.2120761644  0.539271956 -1.844342e-01 -0.0672960843
      439  0.0065873557  0.450492486 -9.994889e-02 -0.0900982809
      440  0.5714641266 -0.238535077  2.051394e-01  0.1887845402
      441  0.5941121126  0.157565370  3.441380e-01 -0.2274381312
      442 -0.2246415662  0.291629457  7.533244e-02  0.0383512268
      443  0.1678288225  0.322141315 -4.071969e-01 -0.0732346029
      444 -0.3058609691 -0.011644779 -2.753897e-01 -0.4304197228
      445 -0.1112804795  0.576437363 -2.172012e-01  0.2477229852
      446 -0.2572615480 -0.228570695  2.050201e-01  0.0987986551
      447 -0.4686323389 -0.336009147 -6.873592e-02 -0.2490844988
      448  0.1733438802 -0.335651168  2.087433e-01 -0.3453281264
      449  0.3225652634  0.152369881 -2.449519e-01 -0.3146281404
      450 -0.2182653291  0.134350027  1.714631e-01 -0.1693000734
      451 -0.4742457415  0.133152447 -3.930155e-01  0.4237237648
      452  0.1662263062 -0.135807415 -2.226443e-01  0.5381653822
      453 -0.0848700734 -0.008129737 -7.861896e-02 -0.1974264102
      454 -0.3035480803 -0.069184175 -6.349520e-01  0.0609243341
      455  0.2412737640 -0.079656496  1.292440e-01 -0.2006747795
      456  0.2223176450  0.233136370 -5.075976e-01  0.2193983616
      457  0.0958955130  0.073573078  2.557464e-01  0.3653671961
      458  0.4018335878  0.345491659 -8.051821e-02 -0.3309604438
      459 -0.0875381110 -0.215237903  3.592736e-02 -0.1532316736
      460 -0.0641515022  0.173328878 -7.326332e-02  0.0280252175
      461  0.0382229537  0.189508860 -3.008665e-01  0.1215911965
      462  0.0250502611  0.158060499 -6.656532e-01 -0.2604542438
      463  0.5274212953  0.170971307 -3.372694e-01  0.0537950364
      464 -0.2683937506 -0.351224606 -7.468059e-02  0.5447178889
      465 -0.2308902094  0.269255318 -4.437534e-01  0.2288323034
      466 -0.3898654100 -0.308376085  6.993890e-02 -0.1334651234
      467  0.2343603751  0.255588129  3.244418e-01 -0.3234762611
      468 -0.4538356005  0.215194024 -2.196617e-01  0.1764874758
      469 -0.5630428933  0.121449326  2.240660e-01 -0.1388712463
      470 -0.5695021036  0.191388303 -3.681460e-01  0.2469827964
      471  0.0224561805  0.292167060 -1.052025e-01  0.3159760144
      472 -0.2594346618 -0.298854033 -2.422646e-02  0.1348239841
      473  0.0277200536 -0.032256987  5.068814e-02  0.1834148147
      474 -0.2404450385 -0.368221075  3.127540e-01  0.1148570743
      475 -0.0614992327  0.292105569 -1.067445e-01  0.2354724013
      476  0.0165442558 -0.171168056 -7.809032e-02  0.3276256898
      477 -0.0152777217  0.045075250  1.194499e-01  0.3263137473
      478 -0.2243432162  0.353946184  6.377423e-01  0.2699552386
      479 -0.0447004124  0.256085418  3.299961e-02 -0.2167004603
      480  0.2217082113  0.203131441  1.809113e-01  0.2094998042
      481 -0.2711435062  0.253950971 -7.255028e-01  0.7236328407
      482  0.4746063089  0.175418596 -1.792209e-01  0.1136951910
      483 -0.3179187750  0.040286990  5.810333e-03  0.0635510971
      484 -0.0313382562  0.057604774 -1.386084e-01 -0.5782560460
      485 -0.1462942647 -0.544526656 -3.212731e-01  0.2377113743
      486 -0.3670918806  0.158026056  5.150656e-01  0.0335343197
      487  0.0403540420  0.610540560  1.950205e-01 -0.0105340242
      488 -0.0823299085 -0.244349064  4.543275e-01  0.2984863010
      489 -0.2638614063  0.322061650 -8.659786e-02 -0.0290154034
      490  0.0919538566 -0.131546794 -2.492529e-01  0.2791061524
      491  0.2252388284  0.279995312  3.317766e-01  0.6213321889
      492  0.4234723865 -0.260570812 -2.996250e-01 -0.3787693671
      493  0.1518234018  0.283537964  4.341642e-01 -0.4430619078
      494 -0.4653840861 -0.304992604 -8.376298e-02 -0.0355259280
      495 -0.4915538057 -0.381403645  4.817512e-01  0.4184857848
      496 -0.1356943524 -0.284137412 -9.083455e-02 -0.7669864236
      497  0.1305728791 -0.071212208  1.735485e-01  0.1292892909
      498  0.0132487211  0.162529449  1.379193e-02  0.1163890803
      499  0.3360450529  0.367744810  2.552764e-01  0.3808624495
      500 -0.2319305337 -0.234794277  6.392738e-01 -0.1783423938

# gen_clustloc() works

    Code
      gen_clustloc(p = 4, k = 3)
    Output
                 [,1]       [,2]        [,3]
      [1,]  1.8727238 -0.7444274 -1.12829641
      [2,] -0.9968225  0.9259866  0.07083593
      [3,]  0.7820890 -0.1252220 -0.65686699
      [4,]  1.5232486 -0.4366755 -1.08657315

# gen_hole() works

    Code
      gen_hole(scurve_data, r = 0.5)
    Output
      # A tibble: 970 x 3
             x1    x2      x3
          <dbl> <dbl>   <dbl>
       1 -0.634 1.68  -1.77  
       2  0.610 0.171 -0.207 
       3 -0.773 0.252  1.63  
       4 -0.976 1.81   0.782 
       5  0.602 1.57   1.80  
       6  0.234 1.29  -1.97  
       7 -0.592 1.30  -1.81  
       8 -0.319 0.411  0.0522
       9  0.983 0.463 -0.817 
      10  0.527 1.49  -0.150 
      # i 960 more rows

