% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_curve.R
\name{scurve}
\alias{scurve}
\title{Generate S-curve Data}
\usage{
scurve(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the generated S-curve data.
}
\description{
This function generates S-curve data, which is a commonly used dataset for
testing and visualizing dimensionality reduction algorithms.
}
\examples{
set.seed(20240412)
s_curve_data <- scurve(
  n = 100, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
