% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarySurvey.R
\name{SummarySurvey}
\alias{SummarySurvey}
\title{Summary statistics for sample surveys}
\usage{
SummarySurvey(design = NULL, variables = NULL, conf.level = 0.95,
  rnd = 3)
}
\arguments{
\item{design}{an output form \code{\link{DesignSurvey}} function.}

\item{variables}{\code{\link{character}} \code{\link{vector}} with the type of estimate for each variable contained in \code{design}. Possible types: total, mean, and prop (see details).}

\item{conf.level}{the confidence level required.}

\item{rnd}{the number of decimal places (round) or significant digits (signif) to be used. If \code{NA}, scientific notation is used.}
}
\value{
Matrix with survey summaries. The error (column "Error (%)") for totals and means is equal to the coefficient of variation times \code{conf.level} times 100; for proportions it is equal to the upper confidence limit minus the point estimate times 100, that is, percent points.
}
\description{
Wraps functions for summary statistics from survey package.
}
\details{
The length of \code{variables} must be equal to the length of \code{names(design$variables)} (see examples).
}
\examples{
data("cluster_sample")
data("psu_ssu")

## Calibrated two-stage cluster design
cs <- cluster_sample[ , c("interview_id",
                          "census_tract_id",
                          "number_of_persons",
                          "number_of_dogs",
                          "number_of_cats")]

design <- DesignSurvey(na.omit(cs),
                       psu.ssu = psu_ssu,
                       psu.col = "census_tract_id",
                       ssu.col = "interview_id",
                       cal.col = "number_of_persons",
                       cal.N = 129445)

SummarySurvey(design, c("total", "total", "total"))

}
\references{
Lumley, T. (2011). Complex surveys: A guide to analysis using R (Vol. 565). Wiley.

Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
