% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapkmlPSU.R
\name{MapkmlPSU}
\alias{MapkmlPSU}
\title{Creates *.kml files of a subset of polygons from a polygon shapefile}
\usage{
MapkmlPSU(shape = NULL, psu = NULL, id = NULL, path = ".")
}
\arguments{
\item{shape}{string with the name of a polygon shapefile or an object of \code{\link{class}} \link[sp]{SpatialPolygonsDataFrame} (see examples).}

\item{psu}{the values to be matched.}

\item{id}{column of the *.dbf file with the values to be matched against.}

\item{path}{string indicating the path to the folder containing the shapfile. If the shapefile is in the working directory or if \code{shape} argument is a shapefile, \code{path} can be ignored.}
}
\value{
*.kml files of the subsetted polygons.
}
\description{
Subset polygons acording to the matches between a vector and a specified column from a \link[sp]{SpatialPolygonsDataFrame}.
}
\details{
If there are *.kml files in the working directory, the new created files will overwrite it in case of name matching.

\code{shape} must receive a shapefile with appropriate coordinate reference system, otherwise, \code{MapkmlPSU} report an error.
}
\examples{
data(city)

# Take a sample of 10 PSU.
(selected_psu <- SamplePPS(psu.ssu = city[, c("track_id", "hh")], psu = 10))

## Define shape from shapefile.
shp_path <- system.file("extdata", package="capm")
# The code above used a shapefile avaliable in the
# capm package.
# You might want to write a code like:
# shp.path  <- 'path_to_the_folder_with_the_shapefile'

# Create *kml files of 10 polygons.
\dontrun{
MapkmlPSU(shape = "35SEE250GC_SIR",
          psu = selected_psu[, "selected.psu"],
          id = "CD_GEOCODI", path = shp_path)

## Define the shape argument as an object x of class SpatialPolygonsDataFrame.
MapkmlPSU(shape = x, psu = selected_psu[, "selected.psu"], id = "CD_GEOCODI")
}
}
\references{
\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\code{\link{readShapeSpatial}}
}
