% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl2_to_cape.R
\name{qtl2_to_cape}
\alias{qtl2_to_cape}
\title{Convert qtl2 object to cape format}
\usage{
qtl2_to_cape(cross, genoprobs = NULL, map = NULL, covar = NULL, verbose = TRUE)
}
\arguments{
\item{cross}{a cross object created by the R/qtl2 function read_cross()}

\item{genoprobs}{an optional argument for providing previously calculated genoprobs.
if this parameter is missing, genoprobs are calculated by qtl_to_cape.}

\item{map}{The qtl2 map. This can be omitted if the map is included in the cross 
object as either pmap or gmap. By default the physical map (pmap) is used. 
If it is missing, the genetic map is used. A provided map will be used 
preferentially over a map included in the cross object.}

\item{covar}{Optional matrix of any covariates to be included in the analysis.}

\item{verbose}{A logical value indicating whether to print progress to the screen.
Defaults to TRUE.}
}
\value{
This function returns a list of two elements. The first element is a cape data
object. The second element is a cape genotype object.
}
\description{
This function converts a data object constructed by qtl2 using the read_cross()
function to cape format. It returns a list in which the first element is the
cape data object, and the second element is the cape genotype object.
}
\references{
Carter, G. W., Hays, M., Sherman, A., & Galitski, T. (2012). Use
  of pleiotropy to model genetic interactions in a population. PLoS genetics,
  8(10), e1003010. doi:10.1371/journal.pgen.1003010

Broman, Karl W., Daniel M. Gatti, Petr Simecek, Nicholas A. Furlotte, 
Pjotr Prins, Śaunak Sen, Brian S. Yandell, and Gary A. Churchill. "R/qtl2: software 
for mapping quantitative trait loci with high-dimensional data and multiparent populations." 
Genetics 211, no. 2 (2019): 495-502.
}
