% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_svd.R
\name{plot_svd}
\alias{plot_svd}
\title{Plots eigentraits}
\usage{
plot_svd(
  data_obj,
  orientation = c("vertical", "horizontal"),
  neg_col = "blue",
  pos_col = "brown",
  light_dark = "f",
  pheno_labels = NULL,
  cex_barplot_axis = 1.7,
  cex_barplot_labels = 2,
  cex_barplot_title = 1.7,
  main = "Eigentrait Contributions to Phenotypes",
  cex_main = 2,
  main_x = 0.5,
  main_y = 0.5,
  cex_ET = 1.7,
  ET_label_x = 0.5,
  ET_label_y = 0.5,
  pheno_label_pos = 0.5,
  cex_pheno = 1.7,
  pheno_srt = 90,
  percent_total_variance_x = 0.5,
  percent_total_variance_y = 0.5,
  cex_color_scale = 1,
  cex_var_accounted = 2,
  var_accounted_x = 0,
  var_accounted_y = 0,
  show_var_accounted = FALSE,
  just_selected_et = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{orientation}{string, ("vertical", "horizontal")}

\item{neg_col}{The color to use for negative main effects and interactions
takes the same values as pos_col.}

\item{pos_col}{The color to use for positive main effects and interactions
must be one of "green", "purple", "red", "orange", "blue", "brown", "yellow", "gray"
see \code{\link{get_color}}}

\item{light_dark}{Indicates whether pos_col, neg_col, and bg_col should be selected
from light colors ("l"), dark colors ("d") or the full spectrum from light to dark ("f")}

\item{pheno_labels}{Vector of phenotype names if other than what is stored in the
data object}

\item{cex_barplot_axis}{Size of axis for the bar plot}

\item{cex_barplot_labels}{Size of labels for the bar plot}

\item{cex_barplot_title}{Size of the barplot title}

\item{main}{Title for the plot. Defaults to "Eigentrait Contributions to Phenotypes"}

\item{cex_main}{Size of the overall title}

\item{main_x}{x shift for the overall title}

\item{main_y}{y shift for the overall title}

\item{cex_ET}{Size of the eigentrait labels}

\item{ET_label_x}{x shift for the eigentrait labels}

\item{ET_label_y}{y shift for the eigentrait labels}

\item{pheno_label_pos}{x shift for the trait labels}

\item{cex_pheno}{size of the trait labels}

\item{pheno_srt}{Rotation factor for the trait labels}

\item{percent_total_variance_x}{x shift for the percent total variance labels}

\item{percent_total_variance_y}{y shift for the percent total variance labels}

\item{cex_color_scale}{label size for the color scal}

\item{cex_var_accounted}{size for the variance accounted for labels}

\item{var_accounted_x}{x shift for the variance accounted axis label}

\item{var_accounted_y}{x shift for the variance accounted axis label}

\item{show_var_accounted}{logical}

\item{just_selected_et}{logical}
}
\value{
\code{list("data_obj" = data_obj, "geno_obj" = geno_obj)}
}
\description{
This function plots the results of the singular value
decomposition (SVD) on the phenotypes. Gray bars indicate
the amount of phenotypic variance accounted for by each
eigentrait.
}
\details{
Below the bars is a heatmap indicating how each trait 
contributes to each eigentrait. Colors can be adjusted
to suit preferences.
}
