\encoding{UTF-8}
\name{rankplot}
\alias{rankplot}
\title{Plot Ranking of Chemical Affinities}
\description{
  Plot ranking of chemical affinities of groups of proteins.
}

\usage{
  rankplot(pdat, T = 37, what = "rankdiff", main = NULL, res = 300,
           plot.it = TRUE, xlim = c(-75, -55), ylim = c(-10, 10))
}

\arguments{
  \item{pdat}{list, data object generated by \code{\link{get_pdat}}}
  \item{T}{numeric, temperature in degrees Celsius}
  \item{what}{character, \dQuote{rankdiff} or \dQuote{affinity}}
  \item{main}{character, text to use for title of plot}
  \item{res}{numeric, grid resolution for plot}
  \item{plot.it}{logical, draw a plot?}
  \item{xlim}{numeric, range of x-axis (\logfO2)}
  \item{ylim}{numeric, range of y-axis (\logaH2O)}
}

\details{
This function creates a \logaH2O - \logfO2 diagram showing the relative stabilities of the two groups of proteins in the specified \code{dataset}.
These groups consist of the relatively down- and up-expressed proteins identified by \code{up2} in one of the \code{\link{pdat_}} functions.

The function generates a colored \code{\link{image}} and \code{\link{contour}} plot showing the weighted difference of sums of ranks of chemical affinities of formation of proteins in the two groups (see \code{\link[CHNOSZ]{affinity}} and \code{\link{rankdiff}}).
Increasing intensity of blue or red colors represent higher rankings of the down-expressed (\code{up2==FALSE}) or up-expressed (\code{up2==TRUE}) proteins, respectively.
Alternatively, if \code{what} is \dQuote{affinity}, a maximum affinity diagram is produced (see \code{\link[CHNOSZ]{diagram}} in CHNOSZ), with fields colored red or blue according to the relative expression of the protein.

If \code{main} is NULL, the title for the plot is taken from the description supplied in \code{pdat}.

Set \code{plot.it} to FALSE to skip the plotting and instead return a list containing the computed rank differences and x- and y- values and labels.
}

\examples{
data(canprot)
pdat <- get_pdat("JKMF10")
rankplot(pdat, res=25)
rankplot(pdat, res=25, what="affinity")
}

\seealso{
  \code{\link{get_colors}}
}

\concept{Thermodynamic calculations}
