% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mishler_endem_cols}
\alias{mishler_endem_cols}
\title{Original color palette for plotting results of CANAPE}
\format{
An object of class \code{character} of length 5.
}
\usage{
mishler_endem_cols
}
\description{
Character vector with names corresponding to endemism types
and values corresponding to color codes. Original palette used by
Mishler et al. (2014). May not be distinguishable to people with
color vision deficiency (CVD).
}
\details{
Color scheme:
\itemize{
\item paleo: blue
\item neo: red
\item not significant: beige
\item mixed: light purple
\item super: dark purple
}
}
\examples{
mishler_endem_cols
scales::show_col(mishler_endem_cols)
}
\references{
Mishler, B., Knerr, N., González-Orozco, C. et al.  (2014)
Phylogenetic measures of biodiversity and neo- and paleo-endemism in
Australian Acacia. Nat Commun, 5: 4473. \doi{10.1038/ncomms5473}
}
\seealso{
Other colors: 
\code{\link{cpr_endem_cols_2}},
\code{\link{cpr_endem_cols_3}},
\code{\link{cpr_endem_cols_4}},
\code{\link{cpr_endem_cols}},
\code{\link{cpr_make_pal}()},
\code{\link{cpr_signif_cols_2}},
\code{\link{cpr_signif_cols}},
\code{\link{mishler_signif_cols}}
}
\concept{colors}
\keyword{datasets}
