% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%dot\%}
\alias{\%dot\%}
\title{Numerical and Symbolic Dot Product}
\usage{
x \%dot\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} array.}

\item{y}{\code{numeric} or \code{character} array.}
}
\value{
\code{array}.
}
\description{
The dot product between arrays with different dimensions is computed by taking the inner product on the last dimensions of the two arrays.
}
\details{
The dot product between two arrays \code{A} and \code{B} is computed as:
\deqn{C_{i_1\dots i_m} = \sum_{j_1\dots j_n} A_{i_1\dots i_mj_1\dots j_n}B_{j_1\dots j_n}}
}
\examples{
### inner product 
x <- array(1:12, dim = c(3,4))
x \%dot\% x

### dot product 
x <- array(1:24, dim = c(3,2,4))
y <- array(letters[1:8], dim = c(2,4))
x \%dot\% y

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other basic arithmetic: 
\code{\link{\%diff\%}()},
\code{\link{\%div\%}()},
\code{\link{\%inner\%}()},
\code{\link{\%kronecker\%}()},
\code{\link{\%outer\%}()},
\code{\link{\%prod\%}()},
\code{\link{\%sum\%}()}
}
\concept{basic arithmetic}
