% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{can_i_stream}
\alias{can_i_stream}
\alias{can_i_stream_id}
\alias{can_i_stream_it}
\title{Query CanIStream.It}
\usage{
can_i_stream_id(movie_id, media_type = c("streaming", "rental", "purchase",
  "dvd", "xfinity"), user_agent = NULL, offline = FALSE)

can_i_stream_it(movie_name, media_type = c("streaming", "rental", "purchase",
  "dvd", "xfinity"), user_agent = NULL, offline = FALSE)
}
\arguments{
\item{movie_id}{The movie's ID, found by running \code{\link{find_movie}}}

\item{media_type}{The type to search for: \describe{
  \item{streaming}{Subscription based and free instant streaming services.}
  \item{rental}{Services that offer time limited rentals (24-48 hours) for a small fee.}
  \item{purchase}{Services that offer the ability to purchase a movie forever.}
  \item{dvd}{Services that allow you to purchase or rent a physical dvd/blu-ray disc.}
  \item{xfinity}{Cable Subscription services with online viewing brought to you by Xfinity.}
}}

\item{user_agent}{Allows specification of custom UA}

\item{offline}{A logical flag to simulate the API request}

\item{movie_name}{The movie's name, which will be passed to
\code{\link{find_movie}}}
}
\value{
A data.frame with a row for each service/store and the following
  columns: \describe{
    \item{friendly_name}{The name of the service/store}
    \item{external_id}{The ID of the movie/show}
    \item{price}{The movie's price on the service/store}
    \item{direct_url}{The URL of the movie on the service/store}
    \item{short_url}{The CanIStream.It URL that redirects to service/store}
    \item{last_checked}{The datetime the service was last checked}
  }
}
\description{
Searches for the movie's availability on various online
  services/stores.
}
\details{
The API is a bit slow/unreliable, so if you get a HTTP 504 error,
  just re-run the call.
}
\section{Functions}{
\itemize{
\item \code{can_i_stream_id}: Query CanIStream.It by movie ID and media type

\item \code{can_i_stream_it}: Query CanIStream.It by movie name and media type
}}
\examples{

# Use a saved JSON response for 'Groundhog Day'
can_i_stream_id("4eb0173df5f8079d29000002", "purchase", offline = TRUE)

\dontrun{
  movie_id <- find_movie("The Babadook")$movie_id
  can_i_stream_id(movie_id, "streaming")
}
# Use a saved JSON response for 'Groundhog Day'
can_i_stream_it("Groundhog Day", "purchase", offline = TRUE)
\dontrun{
  can_i_stream_it("A Girl Walks Home Alone At Night")
}
}

